/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.lease;

import org.exolab.jms.lease.LeaseEventListenerIfc;
import org.exolab.jms.lease.LeaseIfc;

public class BaseLease
implements LeaseIfc,
Comparable {
    protected final Object _leasedObject;
    protected long _duration = 0L;
    protected long _expiryTime = 0L;
    protected LeaseEventListenerIfc _listener = null;

    public BaseLease(Object object, long duration, LeaseEventListenerIfc listener) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 'object' is null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Argument 'listener' is null");
        }
        this._leasedObject = object;
        this._duration = duration;
        this._expiryTime = System.currentTimeMillis() + duration;
        this._listener = listener;
    }

    public long getExpiryTime() {
        return this._expiryTime;
    }

    public long getDuration() {
        return this._duration;
    }

    public void setDuration(long duration) {
        this._duration = duration;
        this._expiryTime = System.currentTimeMillis() + duration;
    }

    public long getRemainingTime() {
        return System.currentTimeMillis() - this._expiryTime;
    }

    public Object getLeasedObject() {
        return this._leasedObject;
    }

    public LeaseEventListenerIfc getLeaseEventListener() {
        return this._listener;
    }

    public int compareTo(Object object) {
        BaseLease lease;
        int result = 0;
        if (object instanceof BaseLease && (lease = (BaseLease)object).getExpiryTime() != this.getExpiryTime()) {
            result = lease.getExpiryTime() > this.getExpiryTime() ? -1 : 1;
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this._leasedObject.toString());
        buf.append(" duration = ");
        buf.append(this._duration);
        buf.append(" expiryTime = ");
        buf.append(this._expiryTime);
        return buf.toString();
    }

    protected void notifyLeaseExpired() {
        LeaseEventListenerIfc leaseEventListenerIfc = this._listener;
        synchronized (leaseEventListenerIfc) {
            this._listener.onLeaseExpired(this._leasedObject);
        }
    }
}

