/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.exolab.jms.message.FormatConverter;

class MessageProperties
implements Cloneable,
Externalizable {
    private HashMap _properties = new HashMap(20);
    static final long serialVersionUID = 1L;
    private static final String[] RESERVED_WORDS = new String[]{"and", "between", "escape", "in", "is", "like", "false", "null", "or", "not", "true"};
    private static final String GROUP_ID = "JMSXGroupID";
    private static final String GROUP_SEQ = "JMSXGroupSeq";
    private static final Object[][] JMSX_CLIENT_NAMES = new Object[][]{{"JMSXGroupID", class$java$lang$String == null ? (class$java$lang$String = MessageProperties.class$("java.lang.String")) : class$java$lang$String}, {"JMSXGroupSeq", class$java$lang$Integer == null ? (class$java$lang$Integer = MessageProperties.class$("java.lang.Integer")) : class$java$lang$Integer}};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public Object clone() throws CloneNotSupportedException {
        MessageProperties result = new MessageProperties();
        result._properties = (HashMap)this._properties.clone();
        return result;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(1L);
        out.writeObject(this._properties);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version != 1L) {
            throw new IOException("Incorrect version enountered: " + version + " This version = " + 1L);
        }
        this._properties = (HashMap)in.readObject();
    }

    public void clearProperties() {
        this._properties.clear();
    }

    public boolean propertyExists(String name) {
        return this._properties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return FormatConverter.getBoolean(this._properties.get(name));
    }

    public byte getByteProperty(String name) throws JMSException {
        return FormatConverter.getByte(this._properties.get(name));
    }

    public short getShortProperty(String name) throws JMSException {
        return FormatConverter.getShort(this._properties.get(name));
    }

    public int getIntProperty(String name) throws JMSException {
        return FormatConverter.getInt(this._properties.get(name));
    }

    public long getLongProperty(String name) throws JMSException {
        return FormatConverter.getLong(this._properties.get(name));
    }

    public float getFloatProperty(String name) throws JMSException {
        return FormatConverter.getFloat(this._properties.get(name));
    }

    public double getDoubleProperty(String name) throws JMSException {
        return FormatConverter.getDouble(this._properties.get(name));
    }

    public String getStringProperty(String name) throws JMSException {
        return FormatConverter.getString(this._properties.get(name));
    }

    public Object getObjectProperty(String name) throws JMSException {
        return this._properties.get(name);
    }

    public Enumeration getPropertyNames() {
        return Collections.enumeration(this._properties.keySet());
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setProperty(name, new Boolean(value));
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.setProperty(name, new Byte(value));
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.setProperty(name, new Short(value));
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.setProperty(name, new Integer(value));
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.setProperty(name, new Long(value));
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.setProperty(name, new Float(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setProperty(name, new Double(value));
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.setProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value == null)) {
            throw new MessageFormatException("Message.setObjectProperty() does not support objects of type=" + value.getClass().getName());
        }
        this.setProperty(name, value);
    }

    public void setJMSXRcvTimestamp(long value) {
        this._properties.put("JMSXRcvTimestamp", new Long(value));
    }

    protected void setProperty(String name, Object value) throws JMSException {
        if (name == null) {
            throw new JMSException("<null> is not a valid property name");
        }
        char[] chars = name.toCharArray();
        if (chars.length == 0) {
            throw new JMSException("zero-length name is not a valid property name");
        }
        if (!Character.isJavaIdentifierStart(chars[0])) {
            throw new JMSException("name=" + name + " is not a valid " + "property name");
        }
        int i = 1;
        while (i < chars.length) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                throw new JMSException("name=" + name + " is not a valid " + "property name");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < RESERVED_WORDS.length) {
            if (name.equalsIgnoreCase(RESERVED_WORDS[i2])) {
                throw new JMSException("name=" + name + " is a reserved " + "word; it cannot be used as a " + "property name");
            }
            ++i2;
        }
        if (name.startsWith("JMSX")) {
            boolean found = false;
            int i3 = 0;
            while (i3 < JMSX_CLIENT_NAMES.length) {
                Object[] types = JMSX_CLIENT_NAMES[i3];
                if (types[0].equals(name)) {
                    if (value == null) {
                        throw new MessageFormatException("Property=" + name + " may not be null");
                    }
                    Class type = (Class)types[1];
                    if (!type.equals(value.getClass())) {
                        throw new MessageFormatException("Expected type=" + type.getName() + " for property=" + name + ", but got type=" + value.getClass().getName());
                    }
                    if (name.equals(GROUP_SEQ) && (Integer)value <= 0) {
                        throw new JMSException("JMSXGroupSeq must have a value > 0");
                    }
                    found = true;
                    break;
                }
                ++i3;
            }
            if (!found) {
                throw new JMSException("Property=" + name + " cannot be set by clients");
            }
        }
        this._properties.put(name, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

