/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.AbstractMessageHandle;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.messagemgr.MessageRef;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;

abstract class AbstractConsumerMessageHandle
implements MessageHandle {
    private final MessageHandle _handle;
    private long _consumerId;
    private final String _persistentId;
    private boolean _persistent;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$AbstractConsumerMessageHandle == null ? (class$org$exolab$jms$messagemgr$AbstractConsumerMessageHandle = AbstractConsumerMessageHandle.class$("org.exolab.jms.messagemgr.AbstractConsumerMessageHandle")) : class$org$exolab$jms$messagemgr$AbstractConsumerMessageHandle));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$AbstractConsumerMessageHandle;

    public AbstractConsumerMessageHandle(MessageHandle handle, ConsumerEndpoint consumer) throws JMSException {
        this(handle, consumer.getId(), consumer.getPersistentId());
    }

    public AbstractConsumerMessageHandle(MessageHandle handle, String persistentId) throws JMSException {
        this(handle, -1L, persistentId);
    }

    protected AbstractConsumerMessageHandle(MessageHandle handle, long consumerId, String persistentId) throws JMSException {
        if (handle == null) {
            throw new IllegalArgumentException("Argument 'handle' is null");
        }
        this._handle = handle;
        this._consumerId = consumerId;
        this._persistentId = persistentId;
        this._handle.getMessageRef().reference();
    }

    public String getMessageId() {
        return this._handle.getMessageId();
    }

    public void setDelivered(boolean delivered) {
        this._handle.setDelivered(delivered);
    }

    public boolean getDelivered() {
        return this._handle.getDelivered();
    }

    public int getPriority() {
        return this._handle.getPriority();
    }

    public long getAcceptedTime() {
        return this._handle.getAcceptedTime();
    }

    public long getExpiryTime() {
        return this._handle.getExpiryTime();
    }

    public boolean hasExpired() {
        return this._handle.hasExpired();
    }

    public long getSequenceNumber() {
        return this._handle.getSequenceNumber();
    }

    public JmsDestination getDestination() {
        return this._handle.getDestination();
    }

    public long getConsumerId() {
        return this._consumerId;
    }

    public String getConsumerPersistentId() {
        return this._persistentId;
    }

    public long getConnectionId() {
        return this._handle.getConnectionId();
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public MessageImpl getMessage() throws JMSException {
        return this._handle.getMessage();
    }

    public void add() throws JMSException {
        try {
            DatabaseService service = DatabaseService.getInstance();
            Connection connection = service.getConnection();
            service.getAdapter().addMessageHandle(connection, this);
        }
        catch (PersistenceException exception) {
            String msg = "Failed to make handle persistent";
            _log.error((Object)"Failed to make handle persistent", (Throwable)exception);
            throw new JMSException("Failed to make handle persistent: " + exception.getMessage());
        }
        this._persistent = true;
    }

    public void update() throws JMSException {
        try {
            DatabaseService service = DatabaseService.getInstance();
            Connection connection = service.getConnection();
            service.getAdapter().updateMessageHandle(connection, this);
        }
        catch (PersistenceException exception) {
            String msg = "Failed to update persistent handle";
            _log.error((Object)"Failed to update persistent handle", (Throwable)exception);
            throw new JMSException("Failed to update persistent handle: " + exception.getMessage());
        }
    }

    public void destroy() throws JMSException {
        if (this._persistent) {
            try {
                DatabaseService service = DatabaseService.getInstance();
                Connection connection = service.getConnection();
                service.getAdapter().removeMessageHandle(connection, this);
            }
            catch (PersistenceException exception) {
                String msg = "Failed to destroy persistent handle";
                _log.error((Object)"Failed to destroy persistent handle", (Throwable)exception);
                throw new JMSException("Failed to destroy persistent handle: " + exception.getMessage());
            }
        }
        this._handle.destroy();
        this._persistent = false;
    }

    public void release() throws JMSException {
        if (this._handle instanceof AbstractMessageHandle) {
            ((AbstractMessageHandle)this._handle).release(this);
        } else {
            this._handle.release();
        }
    }

    public MessageRef getMessageRef() {
        return this._handle.getMessageRef();
    }

    protected void setConsumerId(long consumerId) {
        this._consumerId = consumerId;
    }

    protected void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

