/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.lease.LeaseEventListenerIfc;
import org.exolab.jms.lease.LeaseManager;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.DefaultMessageCache;
import org.exolab.jms.messagemgr.DestinationCache;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.messagemgr.MessageLease;
import org.exolab.jms.messagemgr.MessageRef;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;

public abstract class AbstractDestinationCache
implements DestinationCache,
LeaseEventListenerIfc {
    private final JmsDestination _destination;
    private DefaultMessageCache _cache = new DefaultMessageCache();
    private Map _consumers = Collections.synchronizedMap(new HashMap());
    private final HashMap _leases = new HashMap();
    private final DatabaseService _database;
    private final LeaseManager _leaseMgr;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$AbstractDestinationCache == null ? (class$org$exolab$jms$messagemgr$AbstractDestinationCache = AbstractDestinationCache.class$("org.exolab.jms.messagemgr.AbstractDestinationCache")) : class$org$exolab$jms$messagemgr$AbstractDestinationCache));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$AbstractDestinationCache;

    public AbstractDestinationCache(JmsDestination destination, DatabaseService database, LeaseManager leases) {
        if (destination == null) {
            throw new IllegalArgumentException("Argument 'destination' is null");
        }
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' is null");
        }
        if (leases == null) {
            throw new IllegalArgumentException("Argument 'leases' is null");
        }
        this._destination = destination;
        this._database = database;
        this._leaseMgr = leases;
    }

    public JmsDestination getDestination() {
        return this._destination;
    }

    public boolean addConsumer(ConsumerEndpoint consumer) {
        Long key;
        boolean result = false;
        if (consumer.getDestination().equals(this.getDestination()) && !this._consumers.containsKey(key = new Long(consumer.getId()))) {
            this._consumers.put(key, consumer);
            result = true;
        }
        return result;
    }

    public void removeConsumer(ConsumerEndpoint consumer) {
        Long key = new Long(consumer.getId());
        this._consumers.remove(key);
    }

    public boolean hasConsumers() {
        return !this._consumers.isEmpty();
    }

    public int getMessageCount() {
        return this._cache.getMessageCount();
    }

    public boolean canDestroy() {
        return !this.hasConsumers();
    }

    public synchronized void destroy() {
        MessageLease[] leases;
        this._cache.clear();
        this._consumers.clear();
        HashMap hashMap = this._leases;
        synchronized (hashMap) {
            leases = this._leases.values().toArray(new MessageLease[0]);
            this._leases.clear();
        }
        int i = 0;
        while (i < leases.length) {
            MessageLease lease = leases[i];
            this._leaseMgr.removeLease(lease);
            ++i;
        }
    }

    public void onLeaseExpired(Object object) {
        MessageRef reference = (MessageRef)object;
        String messageId = reference.getMessageId();
        HashMap hashMap = this._leases;
        synchronized (hashMap) {
            this._leases.remove(messageId);
        }
        try {
            this._database.begin();
            if (reference.isPersistent()) {
                this.persistentMessageExpired(reference);
            } else {
                this.messageExpired(reference);
            }
            reference.destroy();
            this._database.commit();
        }
        catch (Exception exception) {
            _log.error((Object)"Failed to expire message", (Throwable)exception);
            try {
                this._database.rollback();
            }
            catch (PersistenceException error) {
                _log.warn((Object)"Failed to rollback", (Throwable)error);
            }
        }
    }

    public void collectGarbage(boolean aggressive) {
        if (aggressive) {
            this._cache.clearPersistentMessages();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Evicted all persistent messages from cache " + this.getDestination().getName()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("DESTCACHE -" + this.getDestination().getName() + " Messages: P[" + this._cache.getPersistentCount() + "] T[" + this._cache.getTransientCount() + "] Total: [" + this._cache.getMessageCount() + "]"));
        }
    }

    protected void addMessage(MessageRef reference, MessageImpl message) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("addMessage(reference=[JMSMessageID=" + reference.getMessageId() + "])"));
        }
        this._cache.addMessage(reference, message);
    }

    protected DefaultMessageCache getMessageCache() {
        return this._cache;
    }

    protected ConsumerEndpoint getConsumerEndpoint(long consumerId) {
        return (ConsumerEndpoint)this._consumers.get(new Long(consumerId));
    }

    protected ConsumerEndpoint[] getConsumerArray() {
        return this._consumers.values().toArray(new ConsumerEndpoint[0]);
    }

    protected void messageExpired(MessageRef reference) throws JMSException {
        String messageId = reference.getMessageId();
        ConsumerEndpoint[] consumers = this.getConsumerArray();
        int i = 0;
        while (i < consumers.length) {
            consumers[i].messageRemoved(messageId);
            ++i;
        }
    }

    protected void persistentMessageExpired(MessageRef reference) throws JMSException, PersistenceException {
        String messageId = reference.getMessageId();
        ConsumerEndpoint[] consumers = this.getConsumerArray();
        int i = 0;
        while (i < consumers.length) {
            consumers[i].persistentMessageRemoved(messageId);
            ++i;
        }
    }

    protected void checkMessageExpiry(MessageRef reference, MessageImpl message) throws JMSException {
        this.checkMessageExpiry(reference, message.getJMSExpiration());
    }

    protected void checkMessageExpiry(MessageRef reference, long expiryTime) {
        if (expiryTime != 0L) {
            HashMap hashMap = this._leases;
            synchronized (hashMap) {
                if (!this._leases.containsKey(reference.getMessageId())) {
                    long duration = expiryTime - System.currentTimeMillis();
                    if (duration <= 0L) {
                        duration = 1L;
                    }
                    MessageLease lease = new MessageLease(reference, duration, (LeaseEventListenerIfc)this);
                    this._leaseMgr.addLease(lease);
                    this._leases.put(reference.getMessageId(), lease);
                }
            }
        }
    }

    public abstract void returnMessageHandle(MessageHandle var1);

    public abstract void persistentMessageAdded(JmsDestination var1, MessageImpl var2) throws JMSException, PersistenceException;

    public abstract void messageAdded(JmsDestination var1, MessageImpl var2) throws JMSException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

