/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.DestinationCache;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.messagemgr.MessageRef;

public abstract class AbstractMessageHandle
implements MessageHandle {
    private DestinationCache _cache;
    private MessageRef _reference;
    private final String _messageId;
    private boolean _delivered = false;
    private final int _priority;
    private long _acceptedTime;
    private final long _sequenceNumber;
    private long _expiryTime;
    private final JmsDestination _destination;
    private final long _consumerId;
    private final long _connectionId;

    public AbstractMessageHandle(DestinationCache cache, MessageRef reference, MessageImpl message) throws JMSException {
        if (cache == null) {
            throw new IllegalArgumentException("Argument 'cache' is null");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Argument 'reference' is null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Argument 'message' is null");
        }
        this._cache = cache;
        this._messageId = message.getMessageId().getId();
        this._delivered = message.getJMSRedelivered();
        this._priority = message.getJMSPriority();
        this._acceptedTime = message.getAcceptedTime();
        this._sequenceNumber = message.getSequenceNumber();
        this._expiryTime = message.getJMSExpiration();
        this._destination = (JmsDestination)message.getJMSDestination();
        this._consumerId = message.getConsumerId();
        this._connectionId = message.getConnectionId();
        this._reference = reference;
    }

    public AbstractMessageHandle(String messageId, int priority, long acceptedTime, long sequenceNumber, long expiryTime, JmsDestination destination) {
        if (messageId == null) {
            throw new IllegalArgumentException("Argument 'messageId' is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Argument 'destination' is null");
        }
        this._messageId = messageId;
        this._priority = priority;
        this._acceptedTime = acceptedTime;
        this._sequenceNumber = sequenceNumber;
        this._expiryTime = expiryTime;
        this._destination = destination;
        this._consumerId = -1L;
        this._connectionId = -1L;
    }

    public String getMessageId() {
        return this._messageId;
    }

    public MessageImpl getMessage() throws JMSException {
        if (this._reference == null) {
            throw new JMSException("Cannot get message with identifier=" + this._messageId + ": MessageRef null");
        }
        return this._reference.getMessage();
    }

    public void setDelivered(boolean delivered) {
        this._delivered = delivered;
    }

    public boolean getDelivered() {
        return this._delivered;
    }

    public int getPriority() {
        return this._priority;
    }

    public long getAcceptedTime() {
        return this._acceptedTime;
    }

    public long getExpiryTime() {
        return this._expiryTime;
    }

    public boolean hasExpired() {
        return this._expiryTime != 0L && this._expiryTime <= System.currentTimeMillis();
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public JmsDestination getDestination() {
        return this._destination;
    }

    public long getConsumerId() {
        return this._consumerId;
    }

    public String getConsumerPersistentId() {
        return null;
    }

    public long getConnectionId() {
        return this._connectionId;
    }

    public boolean isPersistent() {
        return false;
    }

    public boolean equals(Object object) {
        boolean result = object instanceof MessageHandle;
        if (result) {
            result = this._messageId.equals(((MessageHandle)object).getMessageId());
        }
        return result;
    }

    public int hashCode() {
        return this._messageId.hashCode();
    }

    public String toString() {
        return "MessageHandle : " + this._priority + ":" + this.getAcceptedTime() + ":" + this.getSequenceNumber() + ":" + this._messageId;
    }

    public void destroy() throws JMSException {
        this.getMessageRef().dereference();
    }

    public void release() throws JMSException {
        if (this._cache == null) {
            throw new IllegalStateException("Can't release message: not associated with any cache");
        }
        this._cache.returnMessageHandle(this);
    }

    public MessageRef getMessageRef() {
        return this._reference;
    }

    protected void setMessageRef(MessageRef reference) {
        this._reference = reference;
    }

    protected void setDestinationCache(DestinationCache cache) {
        this._cache = cache;
    }

    protected void release(MessageHandle handle) throws JMSException {
        if (this._cache == null) {
            throw new IllegalStateException("Can't release message: not associated with any cache");
        }
        this._cache.returnMessageHandle(handle);
    }

    public abstract void update() throws JMSException;

    public abstract void add() throws JMSException;
}

