/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import javax.jms.JMSException;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.MessageRef;

abstract class AbstractMessageRef
implements MessageRef {
    private String _messageId;
    private final boolean _persistent;
    private volatile int _count;

    public AbstractMessageRef(String messageId, boolean persistent) {
        this._messageId = messageId;
        this._persistent = persistent;
        this._count = 0;
    }

    public String getMessageId() {
        return this._messageId;
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public synchronized void reference() throws JMSException {
        if (this.isDestroyed()) {
            throw new JMSException("Cannot reference message, JMSMessageID=" + this._messageId + ". Message has been destroyed");
        }
        ++this._count;
    }

    public synchronized void dereference() throws JMSException {
        if (!this.isDestroyed() && --this._count <= 0) {
            this.destroy();
            this.setDestroyed();
        }
    }

    protected boolean isDestroyed() {
        return this._count < 0;
    }

    protected void setDestroyed() {
        this._count = -1;
    }

    public abstract void destroy() throws JMSException;

    public abstract MessageImpl getMessage() throws JMSException;
}

