/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.messagemgr.AbstractConsumerEndpoint;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.DurableConsumerEndpoint;
import org.exolab.jms.messagemgr.QueueBrowserEndpoint;
import org.exolab.jms.messagemgr.QueueConsumerEndpoint;
import org.exolab.jms.messagemgr.QueueDestinationCache;
import org.exolab.jms.messagemgr.TopicConsumerEndpoint;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.service.Service;
import org.exolab.jms.service.ServiceException;

public class ConsumerManagerImpl
extends Service
implements ConsumerManager {
    private final DestinationManager _destinations;
    private final DatabaseService _database;
    private HashMap _consumers = new HashMap();
    private HashMap _endpoints = new HashMap();
    private HashMap _destToConsumerMap = new HashMap();
    private HashMap _wildcardConsumers = new HashMap();
    private long _consumerIdSeed = 0L;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$ConsumerManagerImpl == null ? (class$org$exolab$jms$messagemgr$ConsumerManagerImpl = ConsumerManagerImpl.class$("org.exolab.jms.messagemgr.ConsumerManagerImpl")) : class$org$exolab$jms$messagemgr$ConsumerManagerImpl));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$ConsumerManagerImpl;

    public ConsumerManagerImpl(DestinationManager destinations, DatabaseService database) {
        if (destinations == null) {
            throw new IllegalArgumentException("Argument 'destinations' is null");
        }
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' is null");
        }
        this._destinations = destinations;
        this._database = database;
    }

    public synchronized void subscribe(JmsTopic topic, String name, String clientID) throws JMSException {
        this.createInactiveDurableConsumer(topic, name, clientID);
    }

    public synchronized void unsubscribe(String name, String clientID) throws JMSException {
        DurableConsumerEndpoint consumer;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("unsubscribe(name=" + name + ", clientID=" + clientID + ")"));
        }
        if ((consumer = (DurableConsumerEndpoint)this._endpoints.remove(name)) == null) {
            throw new InvalidDestinationException("Durable consumer " + name + " is not defined.");
        }
        if (consumer.isActive()) {
            throw new JMSException("Cannot remove durable consumer=" + name + ": consumer is active");
        }
        consumer.close();
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            this._database.getAdapter().removeDurableConsumer(connection, name);
            this.removeConsumerEntry(name);
            this._database.commit();
        }
        catch (PersistenceException exception) {
            String msg = "Failed to remove durable consumer, name=" + name;
            this.rethrow(msg, exception);
        }
    }

    public synchronized void unsubscribe(JmsTopic topic) throws JMSException {
        List list = (List)this._destToConsumerMap.get(topic);
        if (list != null) {
            ConsumerEntry[] consumers = list.toArray(new ConsumerEntry[0]);
            int i = 0;
            while (i < consumers.length) {
                ConsumerEntry consumer = consumers[i];
                if (consumer.isDurable()) {
                    this.unsubscribe(consumer.getName(), consumer.getClientID());
                }
                ++i;
            }
        }
        this.removeFromConsumerCache(topic);
    }

    public synchronized ConsumerEndpoint createConsumer(JmsDestination destination, long connectionId, String selector, boolean noLocal) throws JMSException, InvalidSelectorException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("createConsumerEndpoint(destination=" + destination + ", connectionId=" + connectionId + ", selector=" + selector + ", noLocal=" + noLocal + ")"));
        }
        AbstractConsumerEndpoint consumer = null;
        this.getDestination(destination, true);
        long consumerId = this.getNextConsumerId();
        try {
            this._database.begin();
            if (destination instanceof JmsTopic) {
                JmsTopic topic = (JmsTopic)destination;
                consumer = new TopicConsumerEndpoint(consumerId, connectionId, topic, selector, noLocal, this._destinations);
            } else if (destination instanceof JmsQueue) {
                QueueDestinationCache cache = (QueueDestinationCache)this._destinations.getDestinationCache(destination);
                consumer = new QueueConsumerEndpoint(consumerId, cache, selector);
            }
            if (consumer != null) {
                Object key = ConsumerEntry.getConsumerKey(consumer);
                this._endpoints.put(key, consumer);
                this.addConsumerEntry(key, destination, null, false);
            }
            this._database.commit();
        }
        catch (Exception exception) {
            this.rethrow("Failed to create consumer", exception);
        }
        return consumer;
    }

    public synchronized DurableConsumerEndpoint createDurableConsumer(JmsTopic topic, String name, String clientID, long connectionId, boolean noLocal, String selector) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("createDurableConsumer(topic=" + topic + ", name=" + name + ", connectionId=" + connectionId + ", selector=" + selector + ", noLocal=" + noLocal + ")"));
        }
        DurableConsumerEndpoint consumer = this.createInactiveDurableConsumer(topic, name, clientID);
        consumer.activate(connectionId, selector, noLocal);
        return consumer;
    }

    public synchronized ConsumerEndpoint createQueueBrowser(JmsQueue queue, String selector) throws JMSException {
        this.getDestination(queue, true);
        long consumerId = this.getNextConsumerId();
        QueueBrowserEndpoint consumer = null;
        try {
            this._database.begin();
            QueueDestinationCache cache = (QueueDestinationCache)this._destinations.getDestinationCache(queue);
            consumer = new QueueBrowserEndpoint(consumerId, cache, selector);
            Object key = ConsumerEntry.getConsumerKey(consumer);
            this._endpoints.put(key, consumer);
            this.addConsumerEntry(key, queue, null, false);
            this._database.commit();
        }
        catch (Exception exception) {
            this.rethrow("Failed to create browser", exception);
        }
        return consumer;
    }

    public synchronized void closeConsumer(ConsumerEndpoint consumer) {
        Object key;
        ConsumerEndpoint existing;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("closeConsumerEndpoint(consumer=[Id=" + consumer.getId() + ", destination=" + consumer.getDestination() + ")"));
        }
        if ((existing = (ConsumerEndpoint)this._endpoints.get(key = ConsumerEntry.getConsumerKey(consumer))) != null) {
            try {
                this._database.begin();
                if (consumer.getId() != existing.getId()) {
                    _log.error((Object)"Existing endpoint doesn't match that to be closed - retaining");
                } else if (existing instanceof DurableConsumerEndpoint) {
                    DurableConsumerEndpoint durable = (DurableConsumerEndpoint)existing;
                    if (durable.isActive()) {
                        try {
                            durable.deactivate();
                        }
                        catch (JMSException exception) {
                            _log.error((Object)("Failed to deactivate durable consumer=" + durable), (Throwable)exception);
                        }
                    }
                } else {
                    this._endpoints.remove(key);
                    consumer.close();
                    this.removeConsumerEntry(key);
                }
                this._database.commit();
            }
            catch (PersistenceException exception) {
                _log.error((Object)("Failed to close consumer=" + consumer), (Throwable)exception);
                this.rollback();
            }
        }
    }

    public synchronized ConsumerEndpoint getConsumerEndpoint(long consumerId) {
        return (ConsumerEndpoint)this._endpoints.get(new Long(consumerId));
    }

    public synchronized ConsumerEndpoint getConsumerEndpoint(String persistentId) {
        return (ConsumerEndpoint)this._endpoints.get(persistentId);
    }

    public synchronized boolean hasActiveConsumers(JmsDestination destination) {
        boolean result = false;
        ConsumerEndpoint[] consumers = this.getConsumers();
        int i = 0;
        while (i < consumers.length) {
            if (consumers[i].canConsume(destination)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    protected void doStart() throws ServiceException {
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            PersistenceAdapter adapter = this._database.getAdapter();
            HashMap map = adapter.getAllDurableConsumers(connection);
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                String consumer = (String)iter.next();
                String deststr = (String)map.get(consumer);
                JmsDestination dest = this._destinations.getDestination(deststr);
                if (dest == null && !((JmsTopic)(dest = new JmsTopic(deststr))).isWildCard()) {
                    dest = null;
                }
                if (consumer != null && dest != null && dest instanceof JmsTopic) {
                    this.addDurableConsumer((JmsTopic)dest, consumer, null);
                    continue;
                }
                _log.error((Object)("Failure in ConsumerManager.init : " + consumer + ":" + dest));
            }
            this._database.commit();
        }
        catch (Exception exception) {
            this.rollback();
            throw new ServiceException("Failed to initialise ConsumerManager", exception);
        }
    }

    protected synchronized void doStop() {
        Object[] endpoints = this._endpoints.values().toArray();
        int index = 0;
        while (index < endpoints.length) {
            this.closeConsumer((ConsumerEndpoint)endpoints[index]);
            ++index;
        }
        this._endpoints.clear();
        this._consumers.clear();
        this._destToConsumerMap.clear();
        this._wildcardConsumers.clear();
    }

    private DurableConsumerEndpoint createInactiveDurableConsumer(JmsTopic topic, String name, String clientID) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("createInactiveDurableConsumer(topic=" + topic + ", name=" + name + ", clientID=" + clientID + ")"));
        }
        if (!topic.isWildCard()) {
            topic = (JmsTopic)this.getDestination(topic, false);
        }
        if (name == null || name.length() == 0) {
            throw new InvalidDestinationException("Invalid subscription name: " + name);
        }
        DurableConsumerEndpoint endpoint = (DurableConsumerEndpoint)this._endpoints.get(name);
        if (endpoint != null) {
            if (endpoint.isActive()) {
                throw new JMSException("Durable subscriber already exists with name: " + name);
            }
            if (!endpoint.getDestination().equals(topic)) {
                this.unsubscribe(name, clientID);
                endpoint = null;
            }
        }
        if (endpoint == null) {
            try {
                this._database.begin();
                PersistenceAdapter adapter = this._database.getAdapter();
                Connection connection = this._database.getConnection();
                adapter.addDurableConsumer(connection, topic.getName(), name);
                endpoint = this.addDurableConsumer(topic, name, clientID);
                this._database.commit();
            }
            catch (Exception exception) {
                String msg = "Failed to create durable consumer, name=" + name + ", for topic=" + topic.getName();
                this.rethrow(msg, exception);
            }
        }
        return endpoint;
    }

    private DurableConsumerEndpoint addDurableConsumer(JmsTopic topic, String name, String clientID) throws JMSException, PersistenceException {
        this.addConsumerEntry(name, topic, clientID, true);
        long consumerId = this.getNextConsumerId();
        DurableConsumerEndpoint consumer = new DurableConsumerEndpoint(consumerId, topic, name, this._destinations);
        this._endpoints.put(consumer.getPersistentId(), consumer);
        return consumer;
    }

    private void addConsumerEntry(Object key, JmsDestination destination, String clientID, boolean durable) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("addConsumerEntry(key=" + key + ", destination=" + destination + ", clientID=" + clientID + ", durable=" + durable + ")"));
        }
        if (this._consumers.containsKey(key)) {
            throw new JMSException("Duplicate consumer key:" + key);
        }
        ConsumerEntry entry = new ConsumerEntry(key, destination, clientID, durable);
        this._consumers.put(key, entry);
        if (destination instanceof JmsTopic && ((JmsTopic)destination).isWildCard()) {
            this._wildcardConsumers.put(entry, destination);
        } else {
            ArrayList<ConsumerEntry> consumers = (ArrayList<ConsumerEntry>)this._destToConsumerMap.get(destination);
            if (consumers == null) {
                consumers = new ArrayList<ConsumerEntry>();
                this._destToConsumerMap.put(destination, consumers);
            }
            consumers.add(entry);
        }
    }

    private void removeConsumerEntry(Object key) {
        ConsumerEntry entry;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("removeConsumerEntry(key=" + key + ")"));
        }
        if ((entry = (ConsumerEntry)this._consumers.remove(key)) != null) {
            JmsDestination dest = entry.getDestination();
            if (dest instanceof JmsTopic && ((JmsTopic)dest).isWildCard()) {
                this._wildcardConsumers.remove(entry);
            } else {
                List consumers = (List)this._destToConsumerMap.get(dest);
                if (consumers != null) {
                    consumers.remove(entry);
                    if (consumers.isEmpty()) {
                        this._destToConsumerMap.remove(dest);
                    }
                }
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("removeConsumerEntry(key=" + key + "): consumer not found"));
        }
    }

    private void removeFromConsumerCache(JmsDestination destination) {
        this._destToConsumerMap.remove(destination);
    }

    private long getNextConsumerId() {
        return ++this._consumerIdSeed;
    }

    private JmsDestination getDestination(JmsDestination destination, boolean create) throws InvalidDestinationException, JMSException {
        JmsDestination result;
        String name = destination.getName();
        JmsDestination existing = this._destinations.getDestination(name);
        if (existing == null) {
            if (!create) {
                throw new InvalidDestinationException("No destination with name=" + name + " exists");
            }
            this._destinations.createDestination(destination);
            result = this._destinations.getDestination(destination.getName());
        } else {
            if (!destination.getClass().getName().equals(existing.getClass().getName())) {
                throw new InvalidDestinationException("Mismatched destination properties for destination with name=" + name);
            }
            if (existing.getPersistent() != destination.getPersistent()) {
                throw new InvalidDestinationException("Mismatched destination properties for destination with name=" + name);
            }
            result = existing;
        }
        return result;
    }

    private ConsumerEndpoint[] getConsumers() {
        return this._endpoints.values().toArray(new ConsumerEndpoint[0]);
    }

    private void rollback() {
        try {
            if (this._database.isTransacted()) {
                this._database.rollback();
            }
        }
        catch (PersistenceException error) {
            _log.warn((Object)"Failed to rollback after error", (Throwable)error);
        }
    }

    private void rethrow(String message, Exception exception) throws JMSException {
        this.rollback();
        if (exception instanceof JMSException) {
            _log.debug((Object)message, (Throwable)exception);
            throw (JMSException)((Object)exception);
        }
        _log.error((Object)message, (Throwable)exception);
        throw new JMSException(exception.getMessage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ConsumerEntry {
        private final Object _key;
        private final JmsDestination _destination;
        private final String _clientID;
        private final boolean _durable;

        public ConsumerEntry(Object key, JmsDestination destination, String clientID, boolean durable) {
            this._key = key;
            this._destination = destination;
            this._clientID = clientID;
            this._durable = durable;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof ConsumerEntry) {
                result = ((ConsumerEntry)obj)._key.equals(this._key);
            }
            return result;
        }

        public Object getKey() {
            return this._key;
        }

        public String getName() {
            return this._key instanceof String ? (String)this._key : null;
        }

        public JmsDestination getDestination() {
            return this._destination;
        }

        public String getClientID() {
            return this._clientID;
        }

        public boolean isDurable() {
            return this._durable;
        }

        public static Object getConsumerKey(ConsumerEndpoint consumer) {
            Object key = null;
            String id = consumer.getPersistentId();
            key = id != null ? id : new Long(consumer.getId());
            return key;
        }
    }
}

