/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.MessageCache;
import org.exolab.jms.messagemgr.MessageRef;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.PersistenceException;

final class DefaultMessageCache
implements MessageCache {
    private final Map _transient = new HashMap(1023);
    private final Map _persistent = new HashMap(1023);
    private final Map _references = new HashMap(1023);
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$DefaultMessageCache == null ? (class$org$exolab$jms$messagemgr$DefaultMessageCache = DefaultMessageCache.class$("org.exolab.jms.messagemgr.DefaultMessageCache")) : class$org$exolab$jms$messagemgr$DefaultMessageCache));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$DefaultMessageCache;

    DefaultMessageCache() {
    }

    public synchronized void addMessage(MessageRef reference, MessageImpl message) {
        String messageId = reference.getMessageId();
        if (reference.isPersistent()) {
            this._persistent.put(messageId, message);
        } else {
            this._transient.put(messageId, message);
        }
        this.addMessageRef(messageId, reference);
    }

    public synchronized void addMessageRef(MessageRef reference) {
        this.addMessageRef(reference.getMessageId(), reference);
    }

    public synchronized MessageRef getMessageRef(String messageId) {
        return (MessageRef)this._references.get(messageId);
    }

    public synchronized MessageImpl getMessage(MessageRef reference) throws JMSException {
        MessageImpl message;
        String messageId = reference.getMessageId();
        if (reference.isPersistent()) {
            message = (MessageImpl)this._persistent.get(messageId);
            if (message == null) {
                try {
                    DatabaseService service = DatabaseService.getInstance();
                    PersistenceAdapter adapter = service.getAdapter();
                    Connection connection = service.getConnection();
                    message = adapter.getMessage(connection, messageId);
                }
                catch (PersistenceException exception) {
                    String msg = "Failed to retrieve message";
                    _log.error((Object)"Failed to retrieve message", (Throwable)exception);
                    throw new JMSException("Failed to retrieve message: " + exception.getMessage());
                }
                if (message != null) {
                    this._persistent.put(messageId, message);
                }
            }
        } else {
            message = (MessageImpl)this._transient.get(messageId);
        }
        if (message != null && !message.getReadOnly()) {
            message.setReadOnly(true);
        }
        return message;
    }

    public synchronized void destroy(MessageRef reference) throws JMSException {
        String messageId = reference.getMessageId();
        if (this._references.remove(messageId) != null) {
            if (reference.isPersistent()) {
                try {
                    DatabaseService service = DatabaseService.getInstance();
                    Connection connection = service.getConnection();
                    PersistenceAdapter adapter = service.getAdapter();
                    adapter.removeMessage(connection, messageId);
                }
                catch (Exception exception) {
                    _log.error((Object)"Failed to remove message", (Throwable)exception);
                    throw new JMSException("Failed to remove message: " + exception.getMessage());
                }
                this._persistent.remove(messageId);
            } else {
                this._transient.remove(messageId);
            }
        }
    }

    public synchronized void clear() {
        this._transient.clear();
        this._persistent.clear();
        this._references.clear();
    }

    public synchronized void clearPersistentMessages() {
        this._persistent.clear();
    }

    public synchronized int getTransientCount() {
        return this._transient.size();
    }

    public synchronized int getPersistentCount() {
        return this._persistent.size();
    }

    public synchronized int getMessageCount() {
        return this._references.size();
    }

    private void addMessageRef(String messageId, MessageRef reference) {
        this._references.put(messageId, reference);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

