/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.gc.GarbageCollectionService;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.DestinationCache;
import org.exolab.jms.messagemgr.DestinationCacheFactory;
import org.exolab.jms.messagemgr.DestinationEventListener;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.MessageManager;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.service.Service;
import org.exolab.jms.service.ServiceException;

public class DestinationManagerImpl
extends Service
implements DestinationManager {
    private final HashMap _destinations = new HashMap();
    private final HashMap _caches = new HashMap();
    private final Object _lock = this._destinations;
    private LinkedList _listeners = new LinkedList();
    private final MessageManager _messages;
    private final DestinationCacheFactory _factory;
    private ConsumerManager _consumers;
    private final DatabaseService _database;
    private final GarbageCollectionService _collector;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$DestinationManagerImpl == null ? (class$org$exolab$jms$messagemgr$DestinationManagerImpl = DestinationManagerImpl.class$("org.exolab.jms.messagemgr.DestinationManagerImpl")) : class$org$exolab$jms$messagemgr$DestinationManagerImpl));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$DestinationManagerImpl;

    public DestinationManagerImpl(MessageManager messages, DestinationCacheFactory factory, DatabaseService database, GarbageCollectionService collector) {
        if (messages == null) {
            throw new IllegalArgumentException("Argument 'messages' is null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 'factory' is null");
        }
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' is null");
        }
        if (collector == null) {
            throw new IllegalArgumentException("Argument 'collector' is null");
        }
        this._messages = messages;
        this._factory = factory;
        this._database = database;
        this._collector = collector;
    }

    public void setConsumerManager(ConsumerManager consumers) {
        this._consumers = consumers;
    }

    public DestinationCache getDestinationCache(JmsDestination destination) throws JMSException {
        DestinationCache result;
        boolean created = false;
        Object object = this._lock;
        synchronized (object) {
            String name = destination.getName();
            destination = this.getExistingDestination(name);
            result = (DestinationCache)this._caches.get(destination);
            if (result == null) {
                this.checkWildcard(destination);
                result = this._factory.createDestinationCache(destination);
                this._caches.put(destination, result);
                this._messages.addEventListener(destination, result);
                created = true;
            }
        }
        if (created) {
            this.notifyCacheAdded(result);
        }
        return result;
    }

    public JmsDestination getDestination(String name) {
        Object object = this._lock;
        synchronized (object) {
            JmsDestination jmsDestination = (JmsDestination)this._destinations.get(name);
            return jmsDestination;
        }
    }

    public void addDestinationEventListener(DestinationEventListener listener) {
        LinkedList linkedList = this._listeners;
        synchronized (linkedList) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    public void removeDestinationEventListener(DestinationEventListener listener) {
        LinkedList linkedList = this._listeners;
        synchronized (linkedList) {
            this._listeners.remove(listener);
        }
    }

    public void createDestination(JmsDestination destination) throws JMSException {
        this.checkWildcard(destination);
        Object object = this._lock;
        synchronized (object) {
            if (this.exists(destination.getName())) {
                throw new InvalidDestinationException("Destination already exists: " + destination.getName());
            }
            if (destination.getPersistent()) {
                this.createPersistentDestination(destination);
            }
            this.addToDestinations(destination);
        }
        this.notifyDestinationAdded(destination);
    }

    public void removeDestination(JmsDestination destination) throws JMSException {
        boolean queue;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("removeDestination(destination=" + destination + ")"));
        }
        boolean bl = queue = (destination = this.getExistingDestination(destination.getName())) instanceof JmsQueue;
        if (!queue) {
            this._consumers.unsubscribe((JmsTopic)destination);
        }
        Object object = this._lock;
        synchronized (object) {
            DestinationCache cache = (DestinationCache)this._caches.get(destination);
            if (cache != null && cache.hasConsumers()) {
                throw new JMSException("Cannot delete destination" + destination + " since there are " + " active consumers.");
            }
        }
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            this._database.getAdapter().removeDestination(connection, destination.getName());
            this.destroyDestinationCache(destination);
            this.removeFromDestinations(destination);
            this._database.commit();
        }
        catch (Exception exception) {
            String msg = "Failed to remove destination " + destination.getName();
            this.cleanup(msg, exception);
        }
        this.notifyDestinationRemoved(destination);
    }

    public void messageAdded(JmsDestination destination, MessageImpl message) throws JMSException {
        if (destination instanceof JmsTopic) {
            if (this._consumers.hasActiveConsumers(destination)) {
                if (!this.exists(destination.getName())) {
                    this.createDestination(destination);
                }
                DestinationCache cache = this.getDestinationCache(destination);
                cache.messageAdded(destination, message);
            }
        } else {
            if (!this.exists(destination.getName())) {
                this.createDestination(destination);
            }
            DestinationCache cache = this.getDestinationCache(destination);
            cache.messageAdded(destination, message);
        }
    }

    public void persistentMessageAdded(JmsDestination destination, MessageImpl message) throws JMSException, PersistenceException {
        DestinationCache cache = this.getDestinationCache(destination);
        cache.persistentMessageAdded(destination, message);
    }

    public List getDestinations() throws JMSException {
        Object object = this._lock;
        synchronized (object) {
            ArrayList arrayList = new ArrayList(this._destinations.values());
            return arrayList;
        }
    }

    public Map getTopicDestinationCaches(JmsTopic topic) {
        HashMap result = new HashMap();
        Object object = this._lock;
        synchronized (object) {
            Iterator iter = this._caches.keySet().iterator();
            while (iter.hasNext()) {
                JmsDestination dest = (JmsDestination)iter.next();
                if (!(dest instanceof JmsTopic) || !topic.match((JmsTopic)dest)) continue;
                result.put(dest, this._caches.get(dest));
            }
        }
        return result;
    }

    public void collectGarbage(boolean aggressive) {
        DestinationCache[] caches;
        int gcCaches = 0;
        int gcDestinations = 0;
        Object object = this._lock;
        synchronized (object) {
            caches = this._caches.values().toArray(new DestinationCache[0]);
        }
        int index = 0;
        while (index < caches.length) {
            DestinationCache cache = caches[index];
            if (cache.canDestroy()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Garbage collecting destination cache=" + cache));
                }
                this.destroyDestinationCache(cache);
                ++gcCaches;
            } else {
                cache.collectGarbage(aggressive);
            }
            ++index;
        }
        Object object2 = this._lock;
        synchronized (object2) {
            JmsDestination[] destinations = this._destinations.values().toArray(new JmsDestination[0]);
            int i = 0;
            while (i < destinations.length) {
                JmsDestination dest = destinations[i];
                if (!dest.getPersistent() && !this._caches.containsKey(dest)) {
                    ++gcDestinations;
                    this._destinations.remove(dest.getName());
                }
                ++i;
            }
            _log.info((Object)("DMGC Collected " + gcCaches + " caches, " + this._caches.size() + " remaining."));
            _log.info((Object)("DMGC Collected " + gcDestinations + " destinations, " + this._destinations.size() + " remaining."));
        }
    }

    protected void doStart() throws ServiceException {
        if (this._consumers == null) {
            throw new ServiceException("ConsumerManager hasn't been initialised");
        }
        this.init();
        this._collector.register(this);
    }

    protected void doStop() throws ServiceException {
        JmsDestination[] destinations;
        this._collector.unregister(this);
        Object object = this._lock;
        synchronized (object) {
            destinations = this._caches.keySet().toArray(new JmsDestination[0]);
        }
        int index = 0;
        while (index < destinations.length) {
            this.destroyDestinationCache(destinations[index]);
            ++index;
        }
        this._caches.clear();
        this._destinations.clear();
        LinkedList linkedList = this._listeners;
        synchronized (linkedList) {
            this._listeners.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void init() throws ServiceException {
        try {
            this._database.begin();
            connection = this._database.getConnection();
            iter = this._database.getAdapter().getAllDestinations(connection);
            this._database.commit();
            if (true) ** GOTO lbl14
        }
        catch (PersistenceException exception) {
            DestinationManagerImpl._log.error((Object)exception, (Throwable)exception);
            this.rollback();
            throw new ServiceException("Failed to get destinations", exception);
        }
        do {
            dest = (JmsDestination)iter.nextElement();
            this.addToDestinations(dest);
lbl14:
            // 2 sources

        } while (iter.hasMoreElements());
    }

    protected boolean exists(String name) {
        return this.getDestination(name) != null;
    }

    protected void destroyDestinationCache(DestinationCache cache) {
        this.destroyDestinationCache(cache.getDestination());
    }

    protected void destroyDestinationCache(JmsDestination dest) {
        Object object = this._lock;
        synchronized (object) {
            DestinationCache cache = (DestinationCache)this._caches.remove(dest);
            if (cache != null) {
                this._messages.removeEventListener(dest);
                this.notifyCacheRemoved(cache);
                cache.destroy();
            }
        }
    }

    private void createPersistentDestination(JmsDestination destination) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("createPersistentDestination(destination=" + destination + ")"));
        }
        boolean queue = destination instanceof JmsQueue;
        PersistenceAdapter adapter = this._database.getAdapter();
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            adapter.addDestination(connection, destination.getName(), queue);
            this._database.commit();
        }
        catch (Exception exception) {
            this.cleanup("Failed to create persistent destination " + destination.getName(), exception);
        }
    }

    private void notifyDestinationAdded(JmsDestination destination) throws JMSException {
        DestinationEventListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].destinationAdded(destination);
            ++i;
        }
    }

    private void notifyDestinationRemoved(JmsDestination destination) throws JMSException {
        DestinationEventListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].destinationRemoved(destination);
            ++i;
        }
    }

    private void notifyCacheAdded(DestinationCache cache) {
        JmsDestination destination = cache.getDestination();
        DestinationEventListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].cacheAdded(destination, cache);
            ++i;
        }
    }

    private void notifyCacheRemoved(DestinationCache cache) {
        JmsDestination destination = cache.getDestination();
        DestinationEventListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].cacheRemoved(destination, cache);
            ++i;
        }
    }

    private void addToDestinations(JmsDestination destination) {
        Object object = this._lock;
        synchronized (object) {
            if (!this._destinations.containsKey(destination.getName())) {
                this._destinations.put(destination.getName(), destination);
            }
        }
    }

    private void removeFromDestinations(JmsDestination destination) {
        Object object = this._lock;
        synchronized (object) {
            this._destinations.remove(destination.getName());
        }
    }

    private JmsDestination getExistingDestination(String name) throws InvalidDestinationException {
        JmsDestination destination = this.getDestination(name);
        if (destination == null) {
            throw new InvalidDestinationException("Destination does not exist:" + name);
        }
        return destination;
    }

    private void checkWildcard(JmsDestination destination) throws InvalidDestinationException {
        if (destination instanceof JmsTopic && ((JmsTopic)destination).isWildCard()) {
            throw new InvalidDestinationException("Wildcarded topics cannot be managed: " + destination.getName());
        }
    }

    private DestinationEventListener[] getListeners() {
        LinkedList linkedList = this._listeners;
        synchronized (linkedList) {
            DestinationEventListener[] destinationEventListenerArray = this._listeners.toArray(new DestinationEventListener[0]);
            return destinationEventListenerArray;
        }
    }

    private void rollback() {
        try {
            this._database.rollback();
        }
        catch (PersistenceException exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    private void cleanup(String message, Exception exception) throws JMSException {
        _log.error((Object)message, (Throwable)exception);
        this.rollback();
        if (exception instanceof JMSException) {
            throw (JMSException)((Object)exception);
        }
        throw new JMSException(message + ": " + exception.getMessage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

