/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import javax.jms.IllegalStateException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.messagemgr.AbstractTopicConsumerEndpoint;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.messagemgr.TopicConsumerMessageHandle;
import org.exolab.jms.messagemgr.TopicDestinationCache;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;

public class DurableConsumerEndpoint
extends AbstractTopicConsumerEndpoint {
    private final String _name;
    private boolean _active = false;
    private final Object _activateLock = new Object();

    public DurableConsumerEndpoint(long consumerId, JmsTopic topic, String name, DestinationManager destinations) throws InvalidSelectorException, JMSException, PersistenceException {
        super(consumerId, -1L, topic, null, false, destinations);
        this._name = name;
        this.init();
        DatabaseService service = DatabaseService.getInstance();
        Connection connection = service.getConnection();
        service.getAdapter().removeExpiredMessageHandles(connection, this._name);
        TopicDestinationCache cache = (TopicDestinationCache)this.getDestinationManager().getDestinationCache(topic);
        List handles = cache.getDurableMessageHandles(this._name);
        Iterator iterator = handles.iterator();
        while (iterator.hasNext()) {
            MessageHandle handle = (MessageHandle)iterator.next();
            TopicConsumerMessageHandle consumer = new TopicConsumerMessageHandle(handle, this);
            this.addMessage(consumer);
        }
    }

    public boolean isPersistent() {
        return true;
    }

    public String getPersistentId() {
        return this._name;
    }

    public void activate(long connectionId, String selector, boolean noLocal) throws JMSException {
        Object object = this._activateLock;
        synchronized (object) {
            if (this._active) {
                throw new IllegalStateException("Durable consumer " + this._name + " is alrady active");
            }
            this.setConnectionId(connectionId);
            this.setSelector(selector);
            this.setNoLocal(noLocal);
            this._active = true;
        }
    }

    public void deactivate() throws JMSException {
        Object object = this._activateLock;
        synchronized (object) {
            if (!this._active) {
                throw new IllegalStateException("Durable consumer " + this._name + " is alrady inactive");
            }
            this.setConnectionId(-1L);
            this.setSelector(null);
            this._active = false;
        }
    }

    public boolean isActive() {
        Object object = this._activateLock;
        synchronized (object) {
            boolean bl = this._active;
            return bl;
        }
    }
}

