/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.MessageManager;
import org.exolab.jms.messagemgr.MessageManagerEventListener;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.service.Service;
import org.exolab.jms.service.ServiceException;

public class MessageMgr
extends Service
implements MessageManager {
    private final DatabaseService _database;
    private DestinationManager _destinations;
    private Map _listeners = Collections.synchronizedMap(new HashMap(1023));
    private long _sequenceNoSeed = 0L;
    private final Object _lock = new Object();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$MessageMgr == null ? (class$org$exolab$jms$messagemgr$MessageMgr = MessageMgr.class$("org.exolab.jms.messagemgr.MessageMgr")) : class$org$exolab$jms$messagemgr$MessageMgr));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$MessageMgr;

    public MessageMgr(DatabaseService database) {
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' is null");
        }
        this._database = database;
    }

    public void setDestinationManager(DestinationManager manager) {
        this._destinations = manager;
    }

    public void prepare(MessageImpl message) throws JMSException {
        if (message == null) {
            throw new JMSException("Null message");
        }
        Destination destination = message.getJMSDestination();
        if (destination == null) {
            throw new InvalidDestinationException("Message has no destination");
        }
        if (!(destination instanceof JmsDestination)) {
            throw new InvalidDestinationException("Destination not a JmsDestination");
        }
        message.setAcceptedTime(new Date().getTime());
        message.setSequenceNumber(this.getNextSequenceNumber());
        message.setReadOnly(true);
    }

    public void add(MessageImpl message) throws JMSException {
        this.prepare(message);
        JmsDestination destination = (JmsDestination)message.getJMSDestination();
        JmsDestination existing = this._destinations.getDestination(destination.getName());
        boolean persistent = existing != null ? existing.getPersistent() : false;
        try {
            this._database.begin();
            if (message.getJMSDeliveryMode() == 2 && persistent) {
                this.addPersistentMessage(message);
            } else {
                this.addNonPersistentMessage(message);
            }
            this._database.commit();
        }
        catch (Exception exception) {
            String msg = "Failed to process message";
            _log.error((Object)"Failed to process message", (Throwable)exception);
            try {
                if (this._database.isTransacted()) {
                    this._database.rollback();
                }
            }
            catch (PersistenceException error) {
                _log.error((Object)error, (Throwable)error);
            }
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            throw new JMSException("Failed to process message: " + exception.getMessage());
        }
    }

    public void addEventListener(JmsDestination destination, MessageManagerEventListener listener) {
        this._listeners.put(destination, listener);
    }

    public void removeEventListener(JmsDestination destination) {
        this._listeners.remove(destination);
    }

    protected void doStart() throws ServiceException {
        if (this._destinations == null) {
            throw new ServiceException("Cannot start service: DestinationManager not initialised");
        }
    }

    private void addNonPersistentMessage(MessageImpl message) throws JMSException {
        JmsDestination destination = (JmsDestination)message.getJMSDestination();
        MessageManagerEventListener listener = this.getEventListener(destination);
        listener.messageAdded(destination, message);
    }

    protected void doStop() throws ServiceException {
        this._listeners.clear();
    }

    private void addPersistentMessage(MessageImpl message) throws JMSException, PersistenceException {
        JmsDestination destination = (JmsDestination)message.getJMSDestination();
        Connection connection = this._database.getConnection();
        this._database.getAdapter().addMessage(connection, message);
        MessageManagerEventListener listener = this.getEventListener(destination);
        listener.persistentMessageAdded(destination, message);
    }

    private MessageManagerEventListener getEventListener(JmsDestination destination) {
        MessageManagerEventListener listener = (MessageManagerEventListener)this._listeners.get(destination);
        if (listener == null) {
            listener = this._destinations;
        }
        return listener;
    }

    private long getNextSequenceNumber() {
        Object object = this._lock;
        synchronized (object) {
            long l = ++this._sequenceNoSeed;
            return l;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

