/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.messagemgr.MessageHandleComparator;

class MessageQueue {
    private final SortedMap _queue = new TreeMap(new MessageHandleComparator());
    private final Map _handles = new HashMap();

    MessageQueue() {
    }

    public synchronized boolean add(MessageHandle handle) {
        boolean added = false;
        if (this._queue.put(handle, handle) == null) {
            this._handles.put(handle.getMessageId(), handle);
            added = true;
        }
        return added;
    }

    public synchronized boolean contains(MessageHandle handle) {
        return this._queue.containsKey(handle);
    }

    public synchronized MessageHandle[] toArray() {
        return this._queue.keySet().toArray(new MessageHandle[0]);
    }

    public synchronized MessageHandle remove(MessageHandle handle) {
        MessageHandle result = (MessageHandle)this._queue.remove(handle);
        if (result != null) {
            this._handles.remove(handle.getMessageId());
        }
        return result;
    }

    public synchronized MessageHandle remove(String messageId) {
        MessageHandle result = (MessageHandle)this._handles.remove(messageId);
        if (result != null) {
            this._queue.remove(result);
        }
        return result;
    }

    public synchronized void clear() {
        this._queue.clear();
        this._handles.clear();
    }

    public synchronized int size() {
        return this._queue.size();
    }

    public synchronized MessageHandle removeFirst() {
        MessageHandle first = null;
        if (this._queue.size() > 0) {
            first = (MessageHandle)this._queue.firstKey();
            this._queue.remove(first);
            this._handles.remove(first.getMessageId());
        }
        return first;
    }
}

