/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.AbstractMessageHandle;
import org.exolab.jms.messagemgr.MessageRef;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;

public class PersistentMessageHandle
extends AbstractMessageHandle {
    private final String _persistentId;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$PersistentMessageHandle == null ? (class$org$exolab$jms$messagemgr$PersistentMessageHandle = PersistentMessageHandle.class$("org.exolab.jms.messagemgr.PersistentMessageHandle")) : class$org$exolab$jms$messagemgr$PersistentMessageHandle));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$PersistentMessageHandle;

    public PersistentMessageHandle(MessageImpl message, String persistentId) throws JMSException {
        this(message.getJMSMessageID(), message.getJMSPriority(), message.getAcceptedTime(), message.getSequenceNumber(), message.getJMSExpiration(), (JmsDestination)message.getJMSDestination(), persistentId);
    }

    public PersistentMessageHandle(String messageId, int priority, long acceptedTime, long sequenceNumber, long expiryTime, JmsDestination destination) {
        this(messageId, priority, acceptedTime, sequenceNumber, expiryTime, destination, null);
    }

    public PersistentMessageHandle(String messageId, int priority, long acceptedTime, long sequenceNumber, long expiryTime, JmsDestination destination, String persistentId) {
        super(messageId, priority, acceptedTime, sequenceNumber, expiryTime, destination);
        this._persistentId = persistentId;
    }

    public boolean isPersistent() {
        return true;
    }

    public void add() throws JMSException {
        try {
            DatabaseService service = DatabaseService.getInstance();
            Connection connection = service.getConnection();
            service.getAdapter().addMessageHandle(connection, this);
        }
        catch (PersistenceException exception) {
            String msg = "Failed to make handle persistent";
            _log.error((Object)"Failed to make handle persistent", (Throwable)exception);
            throw new JMSException("Failed to make handle persistent: " + exception.getMessage());
        }
    }

    public void update() throws JMSException {
        try {
            DatabaseService service = DatabaseService.getInstance();
            Connection connection = service.getConnection();
            service.getAdapter().updateMessageHandle(connection, this);
        }
        catch (PersistenceException exception) {
            String msg = "Failed to update persistent handle";
            _log.error((Object)"Failed to update persistent handle", (Throwable)exception);
            throw new JMSException("Failed to update persistent handle: " + exception.getMessage());
        }
    }

    public void reference(MessageRef reference) throws JMSException {
        reference.reference();
        this.setMessageRef(reference);
    }

    public String getConsumerPersistentId() {
        return this._persistentId;
    }

    public void destroy() throws JMSException {
        try {
            DatabaseService service = DatabaseService.getInstance();
            Connection connection = service.getConnection();
            service.getAdapter().removeMessageHandle(connection, this);
        }
        catch (PersistenceException exception) {
            String msg = "Failed to destroy persistent handle";
            _log.error((Object)"Failed to destroy persistent handle", (Throwable)exception);
            throw new JMSException("Failed to destroy persistent handle: " + exception.getMessage());
        }
        super.destroy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

