/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.AbstractConsumerEndpoint;
import org.exolab.jms.messagemgr.Condition;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.messagemgr.QueueConsumerMessageHandle;
import org.exolab.jms.messagemgr.QueueDestinationCache;

public class QueueConsumerEndpoint
extends AbstractConsumerEndpoint {
    private final QueueDestinationCache _cache;

    public QueueConsumerEndpoint(long consumerId, QueueDestinationCache cache, String selector) throws InvalidSelectorException, JMSException {
        super(consumerId, cache.getDestination(), selector, false);
        cache.addConsumer(this);
        this._cache = cache;
    }

    public int getMessageCount() {
        return this._cache.getMessageCount();
    }

    public boolean messageAdded(MessageHandle handle, MessageImpl message) {
        this.notifyMessageAvailable();
        return true;
    }

    public boolean persistentMessageAdded(MessageHandle handle, MessageImpl message) {
        return this.messageAdded(handle, message);
    }

    public void messageRemoved(String messageId) {
    }

    public void persistentMessageRemoved(String messageId) {
    }

    protected MessageHandle doReceive(Condition cancel) throws JMSException {
        MessageHandle handle = this._cache.getMessage(this.getSelector(), cancel);
        if (handle instanceof QueueConsumerMessageHandle) {
            ((QueueConsumerMessageHandle)handle).setConsumerId(this.getId());
        }
        return handle;
    }

    protected void doClose() {
        this._cache.removeConsumer(this);
    }
}

