/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import org.exolab.jms.messagemgr.Condition;

public class TimedCondition
implements Condition {
    private final long _time;
    private final boolean _before;

    private TimedCondition(long time, boolean before) {
        this._time = time;
        this._before = before;
    }

    public boolean get() {
        long current = System.currentTimeMillis();
        if (this._before) {
            return current < this._time;
        }
        return current >= this._time;
    }

    public static Condition before(long time) {
        return new TimedCondition(TimedCondition.getAbsTime(time), true);
    }

    public static Condition after(long time) {
        return new TimedCondition(TimedCondition.getAbsTime(time), false);
    }

    private static long getAbsTime(long time) {
        return System.currentTimeMillis() + time;
    }
}

