/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.persistence.Consumers;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.persistence.SeedGenerator;

class Destinations {
    private final SeedGenerator _seeds;
    private final Consumers _consumers;
    private final HashMap _destinations = new HashMap();
    private final HashMap _ids = new HashMap();
    private static final String DESTINATION_ID_SEED = "destinationId";

    public Destinations(SeedGenerator seeds, Consumers consumers, Connection connection) throws PersistenceException {
        this._seeds = seeds;
        this._consumers = consumers;
        this.load(connection);
    }

    public synchronized void add(Connection connection, JmsDestination destination) throws PersistenceException {
        PreparedStatement insert = null;
        try {
            try {
                long Id = this._seeds.next(connection, DESTINATION_ID_SEED);
                boolean isQueue = destination instanceof JmsQueue;
                insert = connection.prepareStatement("insert into destinations (name, isqueue, destinationid) values (?, ?, ?)");
                insert.setString(1, destination.getName());
                insert.setBoolean(2, isQueue);
                insert.setLong(3, Id);
                insert.executeUpdate();
                this.cache(destination, Id);
            }
            catch (Exception error) {
                throw new PersistenceException("Destinations.add failed with " + error.toString());
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close(insert);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean remove(Connection connection, JmsDestination destination) throws PersistenceException {
        boolean success = false;
        PreparedStatement deleteDestinations = null;
        PreparedStatement deleteMessages = null;
        PreparedStatement deleteConsumers = null;
        PreparedStatement deleteMessageHandles = null;
        Pair pair = (Pair)this._destinations.get(destination.getName());
        if (pair == null) return success;
        try {
            try {
                deleteDestinations = connection.prepareStatement("delete from destinations where name=?");
                deleteDestinations.setString(1, destination.getName());
                deleteMessages = connection.prepareStatement("delete from messages where destinationId=?");
                deleteMessages.setLong(1, pair.Id);
                deleteMessageHandles = connection.prepareStatement("delete from message_handles where destinationId=?");
                deleteMessageHandles.setLong(1, pair.Id);
                deleteConsumers = connection.prepareStatement("delete from consumers where destinationId=?");
                deleteConsumers.setLong(1, pair.Id);
                deleteDestinations.executeUpdate();
                deleteMessages.executeUpdate();
                deleteMessageHandles.executeUpdate();
                deleteConsumers.executeUpdate();
                this._consumers.removeCached(pair.Id);
                this._destinations.remove(destination.getName());
                this._ids.remove(new Long(pair.Id));
                success = true;
            }
            catch (Exception error) {
                throw new PersistenceException("Failed to remove destination", error);
            }
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            SQLHelper.close(deleteDestinations);
            SQLHelper.close(deleteMessages);
            SQLHelper.close(deleteConsumers);
            SQLHelper.close(deleteMessageHandles);
            throw throwable;
        }
        SQLHelper.close(deleteDestinations);
        SQLHelper.close(deleteMessages);
        SQLHelper.close(deleteConsumers);
        SQLHelper.close(deleteMessageHandles);
        return success;
    }

    public synchronized JmsDestination get(String name) {
        Pair pair = (Pair)this._destinations.get(name);
        return pair != null ? pair.destination : null;
    }

    public synchronized JmsDestination get(long id) {
        Pair pair = (Pair)this._ids.get(new Long(id));
        return pair != null ? pair.destination : null;
    }

    public synchronized long getId(String name) {
        Pair pair = (Pair)this._destinations.get(name);
        return pair != null ? pair.Id : 0L;
    }

    public synchronized Vector getNames() {
        Vector<String> result = new Vector<String>(this._destinations.size());
        Iterator iter = this._destinations.keySet().iterator();
        while (iter.hasNext()) {
            result.add((String)iter.next());
        }
        return result;
    }

    public synchronized Vector getDestinations() {
        Vector<JmsDestination> result = new Vector<JmsDestination>(this._destinations.size());
        Iterator iter = this._destinations.values().iterator();
        while (iter.hasNext()) {
            result.add(((Pair)iter.next()).destination);
        }
        return result;
    }

    public synchronized void close() {
        this._destinations.clear();
        this._ids.clear();
    }

    private void load(Connection connection) throws PersistenceException {
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                select = connection.prepareStatement("select name, isqueue, destinationid from destinations");
                set = select.executeQuery();
                String name = null;
                boolean isQueue = false;
                JmsDestination destination = null;
                long Id = 0L;
                while (set.next()) {
                    name = set.getString(1);
                    isQueue = set.getBoolean(2);
                    destination = isQueue ? new JmsQueue(name) : new JmsTopic(name);
                    Id = set.getLong(3);
                    destination.setPersistent(true);
                    this.cache(destination, Id);
                }
            }
            catch (Exception exception) {
                throw new PersistenceException("Failed to load destinations", exception);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            SQLHelper.close(set);
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close(set);
        SQLHelper.close(select);
    }

    private void cache(JmsDestination destination, long Id) {
        Pair pair = new Pair(destination, Id);
        this._destinations.put(destination.getName(), pair);
        this._ids.put(new Long(Id), pair);
    }

    private static class Pair {
        public JmsDestination destination;
        public long Id;

        public Pair(JmsDestination destination, long Id) {
            this.destination = destination;
            this.Id = Id;
        }
    }
}

