/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.scheduler;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import org.exolab.jms.common.threads.ThreadPoolFactory;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.SchedulerConfiguration;
import org.exolab.jms.service.Service;

public class Scheduler
extends Service {
    private final PooledExecutor _threads;
    private static final int MIN_THREAD_COUNT = 2;
    private static final String SCHEDULER_NAME = "Scheduler";

    public Scheduler(Configuration config, ThreadPoolFactory factory) {
        super(SCHEDULER_NAME);
        SchedulerConfiguration schedConfig = config.getSchedulerConfiguration();
        int count = schedConfig.getMaxThreads();
        if (count < 2) {
            count = 2;
        }
        this._threads = factory.create(SCHEDULER_NAME, (Channel)new LinkedQueue(), count);
        this._threads.setMinimumPoolSize(count);
        this._threads.setKeepAliveTime(-1L);
    }

    public void execute(Runnable task) throws InterruptedException {
        this._threads.execute(task);
    }

    protected void doStop() {
        this._threads.shutdownAfterProcessingCurrentlyQueuedTasks();
    }
}

