/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector;

import java.util.HashSet;
import org.exolab.jms.selector.Add;
import org.exolab.jms.selector.And;
import org.exolab.jms.selector.BetweenExpression;
import org.exolab.jms.selector.BinaryOperator;
import org.exolab.jms.selector.Divide;
import org.exolab.jms.selector.Equal;
import org.exolab.jms.selector.Expression;
import org.exolab.jms.selector.ExpressionFactory;
import org.exolab.jms.selector.Greater;
import org.exolab.jms.selector.GreaterEqual;
import org.exolab.jms.selector.Identifier;
import org.exolab.jms.selector.InExpression;
import org.exolab.jms.selector.IsExpression;
import org.exolab.jms.selector.Less;
import org.exolab.jms.selector.LessEqual;
import org.exolab.jms.selector.LikeExpression;
import org.exolab.jms.selector.Literal;
import org.exolab.jms.selector.Multiply;
import org.exolab.jms.selector.Not;
import org.exolab.jms.selector.NotEqual;
import org.exolab.jms.selector.Or;
import org.exolab.jms.selector.SelectorException;
import org.exolab.jms.selector.Subtract;
import org.exolab.jms.selector.UnaryMinus;
import org.exolab.jms.selector.UnaryOperator;

public final class DefaultExpressionFactory
implements ExpressionFactory {
    public Expression binaryOperator(int operator, Expression left, Expression right) throws SelectorException {
        BinaryOperator result = null;
        switch (operator) {
            case 6: {
                result = new And(left, right);
                break;
            }
            case 5: {
                result = new Or(left, right);
                break;
            }
            case 8: {
                result = new Equal(left, right);
                break;
            }
            case 9: {
                result = new NotEqual(left, right);
                break;
            }
            case 10: {
                result = new Less(left, right);
                break;
            }
            case 11: {
                result = new Greater(left, right);
                break;
            }
            case 12: {
                result = new LessEqual(left, right);
                break;
            }
            case 13: {
                result = new GreaterEqual(left, right);
                break;
            }
            case 14: {
                result = new Add(left, right);
                break;
            }
            case 15: {
                result = new Subtract(left, right);
                break;
            }
            case 16: {
                result = new Multiply(left, right);
                break;
            }
            case 17: {
                result = new Divide(left, right);
                break;
            }
            default: {
                throw new SelectorException("Unknown binary operator type: " + operator);
            }
        }
        return result;
    }

    public Expression unaryOperator(int operator, Expression operand) throws SelectorException {
        UnaryOperator result = null;
        switch (operator) {
            case 7: {
                result = new Not(operand);
                break;
            }
            case 4: {
                result = new UnaryMinus(operand);
                break;
            }
            default: {
                throw new SelectorException("Unknown unary operator type: " + operator);
            }
        }
        return result;
    }

    public Expression identifier(String name) throws SelectorException {
        return new Identifier(name);
    }

    public Expression isNull(Expression identifier) throws SelectorException {
        return new IsExpression((Identifier)identifier);
    }

    public Expression like(Expression identifier, String pattern, String escape) throws SelectorException {
        return new LikeExpression((Identifier)identifier, pattern, escape);
    }

    public Expression between(Expression num1, Expression num2, Expression num3) throws SelectorException {
        return new BetweenExpression(num1, num2, num3);
    }

    public Expression in(Expression identifier, HashSet set) throws SelectorException {
        return new InExpression((Identifier)identifier, set);
    }

    public Expression literal(int type, String text) throws SelectorException {
        Literal result = null;
        switch (type) {
            case 30: {
                result = Literal.approxNumericLiteral(text);
                break;
            }
            case 29: {
                result = Literal.exactNumericLiteral(text);
                break;
            }
            case 26: {
                result = Literal.stringLiteral(text);
                break;
            }
            case 32: {
                result = Literal.booleanLiteral(true);
                break;
            }
            case 31: {
                result = Literal.booleanLiteral(false);
                break;
            }
            default: {
                throw new SelectorException("Unknown literal type: " + type);
            }
        }
        return result;
    }
}

