/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector;

import javax.jms.Message;
import org.exolab.jms.selector.Expression;
import org.exolab.jms.selector.SBool;
import org.exolab.jms.selector.SDouble;
import org.exolab.jms.selector.SLong;
import org.exolab.jms.selector.SObject;
import org.exolab.jms.selector.SString;
import org.exolab.jms.selector.SelectorException;

class Literal
implements Expression {
    private SObject _value = null;

    protected Literal(SObject value) {
        this._value = value;
    }

    public static Literal approxNumericLiteral(String text) throws SelectorException {
        SDouble value = null;
        try {
            value = new SDouble(Double.parseDouble(text));
        }
        catch (NumberFormatException exception) {
            throw new SelectorException("invalid float: " + text);
        }
        return new Literal(value);
    }

    public static Literal exactNumericLiteral(String text) throws SelectorException {
        SLong value = null;
        try {
            value = new SLong(Long.decode(text));
        }
        catch (NumberFormatException exception) {
            throw new SelectorException("invalid integer: " + text);
        }
        return new Literal(value);
    }

    public static Literal stringLiteral(String text) {
        return new Literal(new SString(text)){

            public final String toString() {
                return "'" + this.getValue().toString() + "'";
            }
        };
    }

    public static Literal booleanLiteral(boolean value) {
        SBool bool = SBool.FALSE;
        if (value) {
            bool = SBool.TRUE;
        }
        return new Literal(bool);
    }

    public final SObject evaluate(Message msg) {
        return this._value;
    }

    public String toString() {
        return this.getValue().toString();
    }

    protected final SObject getValue() {
        return this._value;
    }
}

