/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector;

import org.exolab.jms.selector.SBool;
import org.exolab.jms.selector.SNumber;
import org.exolab.jms.selector.SObject;
import org.exolab.jms.selector.SString;
import org.exolab.jms.selector.Type;
import org.exolab.jms.selector.TypeMismatchException;

final class TypeCaster {
    private TypeCaster() {
    }

    public static SBool castToBool(SObject obj, String context) throws TypeMismatchException {
        SBool result = null;
        if (obj instanceof SBool) {
            result = (SBool)obj;
        } else if (obj != null) {
            TypeCaster.typeMismatch(Type.BOOLEAN, obj, context);
        }
        return result;
    }

    public static SNumber castToNumber(SObject obj, String context) throws TypeMismatchException {
        SNumber result = null;
        if (obj instanceof SNumber) {
            result = (SNumber)obj;
        } else if (obj != null) {
            TypeCaster.typeMismatch(Type.NUMERIC, obj, context);
        }
        return result;
    }

    public static SString castToString(SObject obj, String context) throws TypeMismatchException {
        SString result = null;
        if (obj instanceof SString) {
            result = (SString)obj;
        } else if (obj != null) {
            TypeCaster.typeMismatch(Type.STRING, obj, context);
        }
        return result;
    }

    private static void typeMismatch(Type expected, SObject value, String context) throws TypeMismatchException {
        StringBuffer msg = new StringBuffer();
        msg.append("expecting a ");
        msg.append(expected);
        msg.append(" expression");
        if (context != null) {
            msg.append(" for ");
            msg.append(context);
        }
        msg.append(", found a ");
        msg.append(value.type());
        throw new TypeMismatchException(msg.toString());
    }
}

