/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.lang.reflect.Constructor;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.common.threads.ThreadPoolFactory;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.Connector;
import org.exolab.jms.config.ConnectorHelper;
import org.exolab.jms.config.ConnectorResource;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.server.AdminConnectionManager;
import org.exolab.jms.server.NameService;
import org.exolab.jms.server.ServerConnectionFactory;
import org.exolab.jms.server.ServerConnector;
import org.exolab.jms.service.Service;
import org.exolab.jms.service.ServiceException;

public class ConnectorService
extends Service {
    private final Configuration _config;
    private final Authenticator _authenticator;
    private final ServerConnectionFactory _factory;
    private final AdminConnectionManager _manager;
    private final NameService _names;
    private final ThreadPoolFactory _threads;
    private ServerConnector[] _interfaces = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$ConnectorService == null ? (class$org$exolab$jms$server$ConnectorService = ConnectorService.class$("org.exolab.jms.server.ConnectorService")) : class$org$exolab$jms$server$ConnectorService));
    static /* synthetic */ Class class$org$exolab$jms$server$ConnectorService;
    static /* synthetic */ Class class$org$exolab$jms$server$ServerConnector;
    static /* synthetic */ Class class$org$exolab$jms$config$types$SchemeType;
    static /* synthetic */ Class class$org$exolab$jms$config$Configuration;
    static /* synthetic */ Class class$org$exolab$jms$net$connector$Authenticator;
    static /* synthetic */ Class class$org$exolab$jms$server$ServerConnectionFactory;
    static /* synthetic */ Class class$org$exolab$jms$server$AdminConnectionManager;
    static /* synthetic */ Class class$org$exolab$jms$server$NameService;
    static /* synthetic */ Class class$org$exolab$jms$common$threads$ThreadPoolFactory;

    public ConnectorService(Configuration config, Authenticator authenticator, ServerConnectionFactory factory, AdminConnectionManager manager, NameService names, ThreadPoolFactory threads) {
        super("ConnectorService");
        if (config == null) {
            throw new IllegalArgumentException("Argument 'config' is null");
        }
        if (authenticator == null) {
            throw new IllegalArgumentException("Argument 'authenticator' is null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 'factory' is null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 'manager' is null");
        }
        if (names == null) {
            throw new IllegalArgumentException("Arguement 'names' is null");
        }
        if (threads == null) {
            throw new IllegalArgumentException("Argument 'threads' is null");
        }
        this._config = config;
        this._authenticator = authenticator;
        this._factory = factory;
        this._manager = manager;
        this._names = names;
        this._threads = threads;
    }

    protected void doStart() throws ServiceException {
        try {
            Context context = this._names.getInitialContext();
            this.initConnectors(context);
        }
        catch (NamingException exception) {
            throw new ServiceException(exception.getMessage(), exception);
        }
    }

    protected void doStop() throws ServiceException {
        int i = 0;
        while (i < this._interfaces.length) {
            this._interfaces[i].close();
            ++i;
        }
    }

    protected void initConnectors(Context context) throws NamingException, ServiceException {
        Connector[] connectors = this._config.getConnectors().getConnector();
        this._interfaces = new ServerConnector[connectors.length];
        int i = 0;
        while (i < connectors.length) {
            Connector connector = connectors[i];
            this._interfaces[i] = this.initConnector(connector, context);
            ++i;
        }
    }

    protected ServerConnector initConnector(Connector connector, Context context) throws NamingException, ServiceException {
        ServerConnector server;
        Class<?> clazz;
        _log.info((Object)("Creating server interface for the " + connector.getScheme() + " connector"));
        ConnectorResource resource = ConnectorHelper.getConnectorResource(connector.getScheme(), this._config);
        String className = resource.getServer().getImplementationClass();
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException exception) {
            throw new ServiceException("Failed to load class " + className);
        }
        if (!(class$org$exolab$jms$server$ServerConnector == null ? (class$org$exolab$jms$server$ServerConnector = ConnectorService.class$("org.exolab.jms.server.ServerConnector")) : class$org$exolab$jms$server$ServerConnector).isAssignableFrom(clazz)) {
            throw new ServiceException("Class " + className + " does not implement ServerConnector");
        }
        try {
            SchemeType scheme = connector.getScheme();
            Constructor<?> ctor = clazz.getConstructor(class$org$exolab$jms$config$types$SchemeType == null ? (class$org$exolab$jms$config$types$SchemeType = ConnectorService.class$("org.exolab.jms.config.types.SchemeType")) : class$org$exolab$jms$config$types$SchemeType, class$org$exolab$jms$config$Configuration == null ? (class$org$exolab$jms$config$Configuration = ConnectorService.class$("org.exolab.jms.config.Configuration")) : class$org$exolab$jms$config$Configuration, class$org$exolab$jms$net$connector$Authenticator == null ? (class$org$exolab$jms$net$connector$Authenticator = ConnectorService.class$("org.exolab.jms.net.connector.Authenticator")) : class$org$exolab$jms$net$connector$Authenticator, class$org$exolab$jms$server$ServerConnectionFactory == null ? (class$org$exolab$jms$server$ServerConnectionFactory = ConnectorService.class$("org.exolab.jms.server.ServerConnectionFactory")) : class$org$exolab$jms$server$ServerConnectionFactory, class$org$exolab$jms$server$AdminConnectionManager == null ? (class$org$exolab$jms$server$AdminConnectionManager = ConnectorService.class$("org.exolab.jms.server.AdminConnectionManager")) : class$org$exolab$jms$server$AdminConnectionManager, class$org$exolab$jms$server$NameService == null ? (class$org$exolab$jms$server$NameService = ConnectorService.class$("org.exolab.jms.server.NameService")) : class$org$exolab$jms$server$NameService, class$org$exolab$jms$common$threads$ThreadPoolFactory == null ? (class$org$exolab$jms$common$threads$ThreadPoolFactory = ConnectorService.class$("org.exolab.jms.common.threads.ThreadPoolFactory")) : class$org$exolab$jms$common$threads$ThreadPoolFactory);
            server = (ServerConnector)ctor.newInstance(scheme, this._config, this._authenticator, this._factory, this._manager, this._names, this._threads);
        }
        catch (NoSuchMethodException ignore) {
            try {
                server = (ServerConnector)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new ServiceException(exception.getMessage(), exception);
            }
        }
        catch (Exception exception) {
            throw new ServiceException(exception.getMessage(), exception);
        }
        _log.debug((Object)("Created an instance of " + className + " as a server interface"));
        server.init();
        server.bindConnectionFactories(context);
        return server;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

