/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.io.PrintStream;
import javax.naming.NamingException;
import org.apache.log4j.xml.DOMConfigurator;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationLoader;
import org.exolab.jms.config.LoggerConfiguration;
import org.exolab.jms.server.ServerException;
import org.exolab.jms.service.ServiceException;
import org.exolab.jms.service.ServiceManager;
import org.exolab.jms.service.Services;
import org.exolab.jms.util.CommandLine;
import org.exolab.jms.util.Version;

public class JmsServer {
    private Services _services = new ServiceManager();
    private Configuration _config;
    static /* synthetic */ Class class$org$exolab$jms$service$ServiceThreadListener;
    static /* synthetic */ Class class$org$exolab$jms$common$threads$DefaultThreadPoolFactory;
    static /* synthetic */ Class class$org$exolab$jms$events$BasicEventManager;
    static /* synthetic */ Class class$org$exolab$jms$persistence$DatabaseService;
    static /* synthetic */ Class class$org$exolab$jms$scheduler$Scheduler;
    static /* synthetic */ Class class$org$exolab$jms$lease$LeaseManager;
    static /* synthetic */ Class class$org$exolab$jms$gc$GarbageCollectionService;
    static /* synthetic */ Class class$org$exolab$jms$authentication$AuthenticationMgr;
    static /* synthetic */ Class class$org$exolab$jms$authentication$UserManager;
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$DestinationCacheFactory;
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$DestinationManagerImpl;
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$ConsumerManagerImpl;
    static /* synthetic */ Class class$org$exolab$jms$server$ServerConnectionManagerImpl;
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$ResourceManager;
    static /* synthetic */ Class class$org$exolab$jms$server$AdminConnectionFactory;
    static /* synthetic */ Class class$org$exolab$jms$server$AdminConnectionManager;
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$MessageMgr;
    static /* synthetic */ Class class$org$exolab$jms$server$NameService;
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$DestinationBinder;
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$DestinationConfigurator;
    static /* synthetic */ Class class$org$exolab$jms$server$ConnectorService;

    public JmsServer(Configuration config) {
        JmsServer.version();
        this._config = config;
    }

    public JmsServer(String file) throws ServerException {
        JmsServer.version();
        ConfigurationLoader loader = new ConfigurationLoader();
        try {
            this._config = loader.load(file);
        }
        catch (Exception exception) {
            throw new ServerException("Failed to read configuration: " + file, exception);
        }
    }

    public void init() throws NamingException, ServiceException {
        LoggerConfiguration log = this._config.getLoggerConfiguration();
        DOMConfigurator.configure((String)log.getFile());
        try {
            this.registerServices();
            this._services.start();
        }
        catch (ServiceException exception) {
            throw new ServerException("Failed to start services", exception);
        }
    }

    public static void main(String[] args) {
        try {
            CommandLine cmdline = new CommandLine(args);
            boolean helpSet = cmdline.exists("help");
            boolean versionSet = cmdline.exists("version");
            boolean configSet = cmdline.exists("config");
            if (helpSet) {
                JmsServer.usage();
            } else if (versionSet) {
                JmsServer.version();
            } else if (!configSet && args.length != 0) {
                JmsServer.usage();
            } else {
                String config = cmdline.value("config", JmsServer.getOpenJMSHome() + "/config/openjms.xml");
                JmsServer server = new JmsServer(config);
                server.init();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public static void version() {
        System.err.println(Version.TITLE + " " + Version.VERSION);
        System.err.println(Version.COPYRIGHT);
        System.err.println(Version.VENDOR_URL);
    }

    protected static void usage() {
        PrintStream out = System.out;
        out.println("\n\n");
        out.println("=====================================================");
        out.println("Usage information for org.exolab.jms.server.JmsServer");
        out.println("=====================================================");
        out.println("\norg.exolab.jms.server.JmsServer");
        out.println("    [-config <xml config file> | -version | -help]\n");
        out.println("\t-config  file name of xml-based config file\n");
        out.println("\t-version displays OpenJMS version information\n");
        out.println("\t-help    displays this screen\n");
    }

    protected Services getServices() {
        return this._services;
    }

    protected void registerServices() throws ServiceException {
        this._services.addService(this._config);
        this._services.addService(class$org$exolab$jms$service$ServiceThreadListener == null ? (class$org$exolab$jms$service$ServiceThreadListener = JmsServer.class$("org.exolab.jms.service.ServiceThreadListener")) : class$org$exolab$jms$service$ServiceThreadListener);
        this._services.addService(class$org$exolab$jms$common$threads$DefaultThreadPoolFactory == null ? (class$org$exolab$jms$common$threads$DefaultThreadPoolFactory = JmsServer.class$("org.exolab.jms.common.threads.DefaultThreadPoolFactory")) : class$org$exolab$jms$common$threads$DefaultThreadPoolFactory);
        this._services.addService(class$org$exolab$jms$events$BasicEventManager == null ? (class$org$exolab$jms$events$BasicEventManager = JmsServer.class$("org.exolab.jms.events.BasicEventManager")) : class$org$exolab$jms$events$BasicEventManager);
        this._services.addService(class$org$exolab$jms$persistence$DatabaseService == null ? (class$org$exolab$jms$persistence$DatabaseService = JmsServer.class$("org.exolab.jms.persistence.DatabaseService")) : class$org$exolab$jms$persistence$DatabaseService);
        this._services.addService(class$org$exolab$jms$scheduler$Scheduler == null ? (class$org$exolab$jms$scheduler$Scheduler = JmsServer.class$("org.exolab.jms.scheduler.Scheduler")) : class$org$exolab$jms$scheduler$Scheduler);
        this._services.addService(class$org$exolab$jms$lease$LeaseManager == null ? (class$org$exolab$jms$lease$LeaseManager = JmsServer.class$("org.exolab.jms.lease.LeaseManager")) : class$org$exolab$jms$lease$LeaseManager);
        this._services.addService(class$org$exolab$jms$gc$GarbageCollectionService == null ? (class$org$exolab$jms$gc$GarbageCollectionService = JmsServer.class$("org.exolab.jms.gc.GarbageCollectionService")) : class$org$exolab$jms$gc$GarbageCollectionService);
        this._services.addService(class$org$exolab$jms$authentication$AuthenticationMgr == null ? (class$org$exolab$jms$authentication$AuthenticationMgr = JmsServer.class$("org.exolab.jms.authentication.AuthenticationMgr")) : class$org$exolab$jms$authentication$AuthenticationMgr);
        this._services.addService(class$org$exolab$jms$authentication$UserManager == null ? (class$org$exolab$jms$authentication$UserManager = JmsServer.class$("org.exolab.jms.authentication.UserManager")) : class$org$exolab$jms$authentication$UserManager);
        this._services.addService(class$org$exolab$jms$messagemgr$DestinationCacheFactory == null ? (class$org$exolab$jms$messagemgr$DestinationCacheFactory = JmsServer.class$("org.exolab.jms.messagemgr.DestinationCacheFactory")) : class$org$exolab$jms$messagemgr$DestinationCacheFactory);
        this._services.addService(class$org$exolab$jms$messagemgr$DestinationManagerImpl == null ? (class$org$exolab$jms$messagemgr$DestinationManagerImpl = JmsServer.class$("org.exolab.jms.messagemgr.DestinationManagerImpl")) : class$org$exolab$jms$messagemgr$DestinationManagerImpl);
        this._services.addService(class$org$exolab$jms$messagemgr$ConsumerManagerImpl == null ? (class$org$exolab$jms$messagemgr$ConsumerManagerImpl = JmsServer.class$("org.exolab.jms.messagemgr.ConsumerManagerImpl")) : class$org$exolab$jms$messagemgr$ConsumerManagerImpl);
        this._services.addService(class$org$exolab$jms$server$ServerConnectionManagerImpl == null ? (class$org$exolab$jms$server$ServerConnectionManagerImpl = JmsServer.class$("org.exolab.jms.server.ServerConnectionManagerImpl")) : class$org$exolab$jms$server$ServerConnectionManagerImpl);
        this._services.addService(class$org$exolab$jms$messagemgr$ResourceManager == null ? (class$org$exolab$jms$messagemgr$ResourceManager = JmsServer.class$("org.exolab.jms.messagemgr.ResourceManager")) : class$org$exolab$jms$messagemgr$ResourceManager);
        this._services.addService(class$org$exolab$jms$server$AdminConnectionFactory == null ? (class$org$exolab$jms$server$AdminConnectionFactory = JmsServer.class$("org.exolab.jms.server.AdminConnectionFactory")) : class$org$exolab$jms$server$AdminConnectionFactory);
        this._services.addService(class$org$exolab$jms$server$AdminConnectionManager == null ? (class$org$exolab$jms$server$AdminConnectionManager = JmsServer.class$("org.exolab.jms.server.AdminConnectionManager")) : class$org$exolab$jms$server$AdminConnectionManager);
        this._services.addService(class$org$exolab$jms$messagemgr$MessageMgr == null ? (class$org$exolab$jms$messagemgr$MessageMgr = JmsServer.class$("org.exolab.jms.messagemgr.MessageMgr")) : class$org$exolab$jms$messagemgr$MessageMgr);
        this._services.addService(class$org$exolab$jms$server$NameService == null ? (class$org$exolab$jms$server$NameService = JmsServer.class$("org.exolab.jms.server.NameService")) : class$org$exolab$jms$server$NameService);
        this._services.addService(class$org$exolab$jms$messagemgr$DestinationBinder == null ? (class$org$exolab$jms$messagemgr$DestinationBinder = JmsServer.class$("org.exolab.jms.messagemgr.DestinationBinder")) : class$org$exolab$jms$messagemgr$DestinationBinder);
        this._services.addService(class$org$exolab$jms$messagemgr$DestinationConfigurator == null ? (class$org$exolab$jms$messagemgr$DestinationConfigurator = JmsServer.class$("org.exolab.jms.messagemgr.DestinationConfigurator")) : class$org$exolab$jms$messagemgr$DestinationConfigurator);
        this._services.addService(class$org$exolab$jms$server$ConnectorService == null ? (class$org$exolab$jms$server$ConnectorService = JmsServer.class$("org.exolab.jms.server.ConnectorService")) : class$org$exolab$jms$server$ConnectorService);
    }

    private static String getOpenJMSHome() {
        return System.getProperty("openjms.home", System.getProperty("user.dir"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

