/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.codehaus.spice.jndikit.NamingProvider;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.Property;
import org.exolab.jms.server.EmbeddedNameService;

public class NameService {
    private Configuration _config;
    private EmbeddedNameService _embedded;
    private Hashtable _environment;

    public NameService(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("Argument 'config' is null");
        }
        this._config = config;
        if (this._config.getServerConfiguration().getEmbeddedJNDI()) {
            this._embedded = new EmbeddedNameService();
        } else {
            this._environment = new Hashtable();
            Property[] properties = config.getJndiConfiguration().getProperty();
            int index = 0;
            while (index < properties.length) {
                this._environment.put(properties[index].getName(), properties[index].getValue());
                ++index;
            }
        }
    }

    public Context getInitialContext() throws NamingException {
        Context initial = null;
        initial = this._embedded != null ? this._embedded.getInitialContext() : new InitialContext(this._environment);
        return initial;
    }

    public NamingProvider getNamingProvider() {
        return this._embedded != null ? this._embedded.getNamingProvider() : null;
    }
}

