/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import org.exolab.jms.messagemgr.MessageHandle;

class SentMessageCache {
    private final int _ackMode;
    private List _unackedMessages = Collections.synchronizedList(new LinkedList());

    public SentMessageCache(int ackMode) {
        this._ackMode = ackMode;
    }

    public void preSend(MessageHandle handle) throws JMSException {
        handle.setDelivered(true);
        this._unackedMessages.add(handle);
        if (handle.isPersistent()) {
            handle.update();
        }
    }

    public void postSend(MessageHandle handle) throws JMSException {
        if (this._ackMode == 1 || this._ackMode == 3) {
            this._unackedMessages.remove(handle);
            handle.destroy();
        }
    }

    public void acknowledge(String messageId, long consumerId) throws JMSException {
        MessageHandle handle;
        boolean exists = false;
        Iterator iterator = this._unackedMessages.iterator();
        while (iterator.hasNext()) {
            handle = (MessageHandle)iterator.next();
            if (handle.getConsumerId() != consumerId || !handle.getMessageId().equals(messageId)) continue;
            exists = true;
            break;
        }
        if (exists) {
            while (!this._unackedMessages.isEmpty()) {
                handle = (MessageHandle)this._unackedMessages.remove(0);
                handle.destroy();
                if (handle.getConsumerId() == consumerId && handle.getMessageId().equals(messageId)) break;
            }
        }
    }

    public void acknowledgeAll() throws JMSException {
        while (!this._unackedMessages.isEmpty()) {
            MessageHandle handle = (MessageHandle)this._unackedMessages.remove(0);
            handle.destroy();
        }
    }

    public void clear() throws JMSException {
        if (!this._unackedMessages.isEmpty()) {
            MessageHandle[] handles = this._unackedMessages.toArray(new MessageHandle[0]);
            this._unackedMessages.clear();
            int i = 0;
            while (i < handles.length) {
                MessageHandle handle = handles[i];
                handle.release();
                ++i;
            }
        }
    }
}

