/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.Condition;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.ConsumerEndpointListener;
import org.exolab.jms.messagemgr.Flag;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.messagemgr.QueueBrowserEndpoint;
import org.exolab.jms.messagemgr.TimedCondition;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.scheduler.Scheduler;
import org.exolab.jms.scheduler.SerialTask;
import org.exolab.jms.server.SentMessageCache;

class SessionConsumer
implements ConsumerEndpointListener {
    private JmsMessageListener _listener;
    private final HashMap _consumers = new HashMap();
    private final SentMessageCache _sent;
    private final DatabaseService _database;
    private final LinkedList _pending = new LinkedList();
    private Flag _stop = new Flag(true);
    private final Object _restartLock = new Object();
    private final Object _removeLock = new Object();
    private long _consumerId = -1L;
    private final int MAX_MESSAGES = 200;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$SessionConsumer == null ? (class$org$exolab$jms$server$SessionConsumer = SessionConsumer.class$("org.exolab.jms.server.SessionConsumer")) : class$org$exolab$jms$server$SessionConsumer));
    private final SerialTask _runner;
    static /* synthetic */ Class class$org$exolab$jms$server$SessionConsumer;

    public SessionConsumer(int ackMode, DatabaseService database, Scheduler scheduler) {
        this._database = database;
        this._sent = new SentMessageCache(ackMode);
        Runnable task = new Runnable(){

            public void run() {
                SessionConsumer.this.dispatch();
            }
        };
        this._runner = new SerialTask(task, scheduler);
    }

    public synchronized void setMessageListener(JmsMessageListener listener) {
        this._listener = listener;
    }

    public synchronized void addConsumer(ConsumerEndpoint consumer) {
        long id = consumer.getId();
        this._consumers.put(new Long(id), consumer);
        consumer.setListener(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConsumerEndpoint removeConsumer(long consumerId) throws JMSException {
        Object object = this._removeLock;
        synchronized (object) {
            ConsumerEndpoint consumer;
            while (consumerId == this._consumerId) {
                try {
                    this._removeLock.wait();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            SessionConsumer sessionConsumer = this;
            synchronized (sessionConsumer) {
                consumer = (ConsumerEndpoint)this._consumers.remove(new Long(consumerId));
                if (consumer == null) {
                    throw new JMSException("No consumer with id=" + consumerId);
                }
                consumer.setListener(null);
            }
            LinkedList linkedList = this._pending;
            synchronized (linkedList) {
                this._pending.remove(consumer);
                return consumer;
            }
        }
    }

    public synchronized ConsumerEndpoint[] getConsumers() {
        return this._consumers.values().toArray(new ConsumerEndpoint[0]);
    }

    public void setAsynchronous(long consumerId, boolean enable) throws JMSException {
        ConsumerEndpoint consumer = this.getConsumer(consumerId);
        consumer.setAsynchronous(enable);
        if (enable && consumer.getMessageCount() != 0) {
            this.messageAvailable(consumer);
        }
    }

    public void stop() {
        Object object = this._restartLock;
        synchronized (object) {
            this._stop.set(true);
            this._runner.stop();
            _log.debug((Object)"stopped delivery");
        }
    }

    public void start() throws JMSException {
        Object object = this._restartLock;
        synchronized (object) {
            _log.debug((Object)"start");
            this._stop.set(false);
            Iterator i = this._consumers.values().iterator();
            while (i.hasNext()) {
                ConsumerEndpoint consumer = (ConsumerEndpoint)i.next();
                if (!this.needsScheduling(consumer)) continue;
                this.queue(consumer);
            }
            try {
                this._runner.schedule();
            }
            catch (InterruptedException exception) {
                _log.error((Object)"Failed to start worker", (Throwable)exception);
                throw new JMSException("Failed to start worker: " + exception);
            }
        }
    }

    public synchronized void recover() throws JMSException {
        this.stop();
        try {
            this._database.begin();
            this._sent.clear();
            this._database.commit();
        }
        catch (Exception exception) {
            this.rethrow(exception.getMessage(), exception);
        }
        this.start();
    }

    public synchronized void commit() throws JMSException {
        try {
            this._database.begin();
            this._sent.acknowledgeAll();
            this._database.commit();
        }
        catch (OutOfMemoryError exception) {
            this.rethrow("Failed to commit session due to out-of-memory error", exception);
        }
        catch (Exception exception) {
            this.rethrow(exception.getMessage(), exception);
        }
    }

    public synchronized void rollback() throws JMSException {
        this.stop();
        try {
            this._database.begin();
            this._sent.clear();
            this._database.commit();
        }
        catch (Exception exception) {
            this.rethrow(exception.getMessage(), exception);
        }
        this.start();
    }

    public MessageImpl receiveNoWait(long consumerId) throws JMSException {
        MessageImpl result = null;
        if (!this._stop.get()) {
            result = this.doReceive(consumerId, null);
        }
        return result;
    }

    public MessageImpl receive(long consumerId, long wait) throws JMSException {
        MessageImpl result = null;
        Condition condition = wait > 0L ? TimedCondition.before(wait) : new Flag(true);
        if (!this._stop.get()) {
            result = this.doReceive(consumerId, condition);
        } else {
            ConsumerEndpoint consumer = this.getConsumer(consumerId);
            consumer.setWaitingForMessage(condition);
        }
        return result;
    }

    public List browse(long consumerId, int count) throws JMSException {
        ConsumerEndpoint consumer = this.getConsumer(consumerId);
        if (!(consumer instanceof QueueBrowserEndpoint)) {
            throw new JMSException("Can't browse messages: invalid consumer");
        }
        ArrayList<MessageImpl> messages = new ArrayList<MessageImpl>(count);
        try {
            this._database.begin();
            int i = 0;
            while (i < count && !this._stop.get()) {
                MessageHandle handle = consumer.receive(this._stop);
                if (handle == null) break;
                MessageImpl orig = handle.getMessage();
                if (orig == null) continue;
                messages.add(this.copy(orig, handle));
                ++i;
            }
            this._database.commit();
        }
        catch (Exception exception) {
            this.rethrow("Failed to browse messages", exception);
        }
        return messages;
    }

    public synchronized void acknowledge(long consumerId, String messageId) throws JMSException {
        try {
            this._database.begin();
            this._sent.acknowledge(messageId, consumerId);
            this._database.commit();
        }
        catch (Exception exception) {
            this.rethrow("Failed to acknowledge message", exception);
        }
    }

    public synchronized void close() throws JMSException {
        _log.debug((Object)"close");
        this.stop();
        this._listener = null;
        try {
            this._database.begin();
            this._sent.clear();
            this._database.commit();
        }
        catch (Exception exception) {
            this.rethrow(exception.getMessage(), exception);
        }
    }

    public void messageAvailable(ConsumerEndpoint consumer) {
        if (this.queue(consumer)) {
            try {
                this._runner.schedule();
            }
            catch (InterruptedException exception) {
                _log.error((Object)"Failed to schedule worker", (Throwable)exception);
            }
        }
    }

    private void dispatch() {
        boolean empty;
        LinkedList linkedList;
        final Condition timeout = TimedCondition.after(30000L);
        Condition done = new Condition(){

            public boolean get() {
                return SessionConsumer.this._stop.get() || timeout.get();
            }
        };
        _log.debug((Object)"dispatch");
        int sent = 0;
        while (sent < 200 && !done.get()) {
            ConsumerEndpoint consumer;
            linkedList = this._pending;
            synchronized (linkedList) {
                if (this._pending.isEmpty()) {
                    break;
                }
                consumer = (ConsumerEndpoint)this._pending.removeFirst();
            }
            if (!this.wantsMessages(consumer)) continue;
            if (consumer.isAsynchronous()) {
                if (this.send(consumer, done)) {
                    ++sent;
                }
                if (!this.needsScheduling(consumer)) continue;
                this.queue(consumer);
                continue;
            }
            this.notifyMessageAvailable();
        }
        linkedList = this._pending;
        synchronized (linkedList) {
            empty = this._pending.isEmpty();
        }
        if (!empty && !this._stop.get()) {
            try {
                this._runner.schedule();
            }
            catch (InterruptedException exception) {
                _log.error((Object)"Failed to reschedule worker", (Throwable)exception);
            }
        }
        _log.debug((Object)("dispatch[sent=" + sent + "]"));
    }

    private void notifyMessageAvailable() {
        try {
            this._listener.onMessageAvailable();
        }
        catch (RemoteException exception) {
            _log.debug((Object)"Failed to notify client", (Throwable)exception);
        }
    }

    private boolean queue(ConsumerEndpoint consumer) {
        boolean queued = false;
        if (!this._stop.get()) {
            LinkedList linkedList = this._pending;
            synchronized (linkedList) {
                if (!this._pending.contains(consumer)) {
                    this._pending.add(consumer);
                    queued = true;
                }
            }
        }
        return queued;
    }

    private boolean send(ConsumerEndpoint consumer, Condition cancel) {
        boolean sent = false;
        MessageHandle handle = null;
        try {
            Object object;
            this._database.begin();
            try {
                Object object2 = this._removeLock;
                synchronized (object2) {
                    this._consumerId = consumer.getId();
                }
                handle = consumer.receive(cancel);
                if (handle != null) {
                    MessageImpl message = handle.getMessage();
                    if (message != null) {
                        message = this.copy(message, handle);
                        consumer.setWaitingForMessage(null);
                        this._sent.preSend(handle);
                        this._database.commit();
                        sent = this.send(message);
                        if (sent) {
                            this._database.begin();
                            this._sent.postSend(handle);
                            this._database.commit();
                        }
                    }
                } else {
                    this._database.commit();
                }
                Object var8_10 = null;
                object = this._removeLock;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                Object object3 = this._removeLock;
                synchronized (object3) {
                    this._consumerId = -1L;
                    this._removeLock.notify();
                }
                throw throwable;
            }
            synchronized (object) {
                this._consumerId = -1L;
                this._removeLock.notify();
            }
        }
        catch (Exception exception) {
            this.cleanup(exception.getMessage(), exception);
        }
        if (!sent && handle != null) {
            try {
                this._database.begin();
                handle.release();
                this._database.commit();
            }
            catch (Exception exception) {
                this.cleanup("Failed to release unsent message", exception);
            }
        }
        return sent;
    }

    protected boolean send(MessageImpl message) {
        boolean delivered = false;
        try {
            delivered = this._listener.onMessage(message);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("send[JMSMessageID=" + message.getMessageId() + ", delivered=" + delivered + "]"));
            }
        }
        catch (RemoteException exception) {
            _log.info((Object)"Failed to notify client", (Throwable)exception);
        }
        return delivered;
    }

    private boolean wantsMessages(ConsumerEndpoint consumer) {
        boolean result = false;
        if (consumer.isAsynchronous() || consumer.isWaitingForMessage()) {
            result = true;
        }
        return result;
    }

    private boolean needsScheduling(ConsumerEndpoint consumer) {
        boolean result = false;
        if (this.wantsMessages(consumer) && consumer.getMessageCount() != 0) {
            result = true;
        }
        return result;
    }

    private MessageImpl doReceive(long consumerId, final Condition wait) throws JMSException {
        ConsumerEndpoint consumer = this.getConsumer(consumerId);
        Condition cancel = wait != null ? new Condition(){

            public boolean get() {
                return SessionConsumer.this._stop.get() || !wait.get();
            }
        } : this._stop;
        MessageImpl message = null;
        try {
            this._database.begin();
            MessageHandle handle = consumer.receive(cancel);
            if (handle != null && (message = handle.getMessage()) != null) {
                message = this.copy(message, handle);
            }
            if (message == null) {
                consumer.setWaitingForMessage(wait);
            } else {
                consumer.setWaitingForMessage(null);
                this._sent.preSend(handle);
            }
            this._database.commit();
        }
        catch (Exception exception) {
            this.rethrow(exception.getMessage(), exception);
        }
        if (_log.isDebugEnabled() && message != null) {
            _log.debug((Object)("doReceive(consumerId=" + consumerId + ") -> JMSMesssageID=" + message.getMessageId()));
        }
        return message;
    }

    private MessageImpl copy(MessageImpl message, MessageHandle handle) throws JMSException {
        MessageImpl result;
        try {
            result = (MessageImpl)message.clone();
            result.setJMSRedelivered(handle.getDelivered());
            result.setConsumerId(handle.getConsumerId());
        }
        catch (JMSException exception) {
            throw exception;
        }
        catch (CloneNotSupportedException exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new JMSException(exception.getMessage());
        }
        return result;
    }

    private ConsumerEndpoint getConsumer(long consumerId) throws JMSException {
        ConsumerEndpoint consumer = (ConsumerEndpoint)this._consumers.get(new Long(consumerId));
        if (consumer == null) {
            throw new JMSException("Consumer not registered: " + consumerId);
        }
        return consumer;
    }

    private void cleanup(String message, Throwable exception) {
        _log.error((Object)message, exception);
        try {
            if (this._database.isTransacted()) {
                this._database.rollback();
            }
        }
        catch (PersistenceException error) {
            _log.warn((Object)"Failed to rollback after error", (Throwable)error);
        }
    }

    private void rethrow(String message, Throwable exception) throws JMSException {
        this.cleanup(message, exception);
        if (exception instanceof JMSException) {
            throw (JMSException)exception;
        }
        throw new JMSException(exception.getMessage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

