/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.exolab.jms.config.ConfigHelper;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConnectionFactories;
import org.exolab.jms.config.Connector;
import org.exolab.jms.config.ServerConfiguration;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.net.uri.InvalidURIException;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;
import org.exolab.jms.net.util.Properties;
import org.exolab.jms.server.net.ConnectorCfg;

abstract class AbstractConnectorCfg
implements ConnectorCfg {
    private final SchemeType _scheme;
    private final Configuration _config;

    public AbstractConnectorCfg(SchemeType scheme, Configuration config) {
        if (scheme == null) {
            throw new IllegalArgumentException("Argument 'scheme' is null");
        }
        if (config == null) {
            throw new IllegalArgumentException("Argument 'config' is null");
        }
        this._scheme = scheme;
        this._config = config;
    }

    public SchemeType getScheme() {
        return this._scheme;
    }

    public String getConnectURI() {
        return this.getExportURI();
    }

    public String getExportURI() {
        return ConfigHelper.getServerURL(this._scheme, this._config);
    }

    public String getJNDIExportURI() {
        return ConfigHelper.getJndiURL(this._scheme, this._config);
    }

    public String getAdminExportURI() {
        return ConfigHelper.getAdminURL(this._scheme, this._config);
    }

    public Map getConnectProperties() {
        Properties properties = this.getProperties();
        this.populateConnectProperties(properties);
        return properties.getProperties();
    }

    public Map getAcceptProperties() {
        Properties properties = this.getProperties();
        this.populateAcceptProperties(properties);
        return properties.getProperties();
    }

    public ConnectionFactories getConnectionFactories() {
        ConnectionFactories result = null;
        Connector[] connectors = this._config.getConnectors().getConnector();
        int i = 0;
        while (i < connectors.length) {
            if (connectors[i].getScheme().equals(this._scheme)) {
                result = connectors[i].getConnectionFactories();
                break;
            }
            ++i;
        }
        return result;
    }

    protected Configuration getConfiguration() {
        return this._config;
    }

    protected void populateConnectProperties(Properties properties) {
        properties.set("org.exolab.jms.net.orb.provider.uri", this.getConnectURI());
    }

    protected void populateAcceptProperties(Properties properties) {
        properties.set("org.exolab.jms.net.orb.provider.uri", this.getExportURI());
        ServerConfiguration server = this._config.getServerConfiguration();
        properties.set("org.exolab.jms.net.orb.threads.max", server.getMaxThreads());
    }

    protected Properties getProperties() {
        String prefix = "org.exolab.jms.net.";
        prefix = this._scheme.equals(SchemeType.EMBEDDED) ? prefix + "vm" : prefix + this._scheme.toString();
        prefix = prefix + ".";
        return new Properties(prefix);
    }

    protected URI getURI(String scheme, String host, int port) {
        URI result;
        try {
            result = URIHelper.create((String)scheme, (String)this.getHost(host), (int)port);
        }
        catch (InvalidURIException exception) {
            throw new IllegalStateException("Failed to create URI: " + (Object)((Object)exception));
        }
        return result;
    }

    protected URI getURI(String scheme, String host, int port, String path) {
        URI result;
        try {
            result = URIHelper.create((String)scheme, (String)this.getHost(host), (int)port, (String)path);
        }
        catch (InvalidURIException exception) {
            throw new IllegalStateException("Failed to create URI: " + (Object)((Object)exception));
        }
        return result;
    }

    protected String getHost(String host) {
        if (host.equals("localhost")) {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return host;
    }

    protected URI getURI(String uri) {
        URI result;
        try {
            result = URIHelper.parse((String)uri);
        }
        catch (InvalidURIException exception) {
            throw new IllegalStateException("Failed to parse URI: " + uri);
        }
        return result;
    }
}

