/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.net;

import org.exolab.jms.config.ConfigHelper;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.HttpConfigurationType;
import org.exolab.jms.config.ServerConfiguration;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.socket.SocketRequestInfo;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.util.Properties;
import org.exolab.jms.server.net.AbstractConnectorCfg;

abstract class AbstractHTTPConnectorCfg
extends AbstractConnectorCfg {
    private HttpConfigurationType _config;

    public AbstractHTTPConnectorCfg(SchemeType scheme, Configuration config, HttpConfigurationType httpConfig) {
        super(scheme, config);
        if (httpConfig == null) {
            throw new IllegalArgumentException("Argument 'httpConfig' is null");
        }
        this._config = httpConfig;
    }

    public String getConnectURI() {
        return ConfigHelper.getServerURL(this.getScheme(), this.getConfiguration());
    }

    public String getExportURI() {
        return this.getExportURI(this._config.getPort());
    }

    public String getJNDIExportURI() {
        String uri = this._config.getJndiPort() != 0 ? this.getExportURI(this._config.getJndiPort()) : this.getExportURI();
        return uri;
    }

    public String getAdminExportURI() {
        String uri = this._config.getAdminPort() != 0 ? this.getExportURI(this._config.getAdminPort()) : this.getExportURI();
        return uri;
    }

    protected void populateAcceptProperties(Properties properties) {
        URI uri = this.getURI(this.getExportURI());
        try {
            SocketRequestInfo info = new SocketRequestInfo(uri);
            info.setBindAll(this._config.getBindAll());
            info.export(properties);
        }
        catch (ResourceException exception) {
            throw new IllegalStateException(exception.getMessage());
        }
    }

    private String getExportURI(int port) {
        SchemeType scheme = this.getScheme();
        String acceptScheme = scheme.toString() + "-server";
        ServerConfiguration server = this.getConfiguration().getServerConfiguration();
        return this.getURI(acceptScheme, server.getHost(), port).toString();
    }
}

