/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.net;

import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.server.net.AbstractConnectorCfg;
import org.exolab.jms.server.net.ConnectorCfg;
import org.exolab.jms.server.net.HTTPConnectorCfg;
import org.exolab.jms.server.net.HTTPSConnectorCfg;
import org.exolab.jms.server.net.RMIConnectorCfg;
import org.exolab.jms.server.net.TCPConnectorCfg;
import org.exolab.jms.server.net.TCPSConnectorCfg;
import org.exolab.jms.server.net.VMConnectorCfg;

public class ConnectorCfgFactory {
    public static ConnectorCfg create(SchemeType scheme, Configuration config) {
        AbstractConnectorCfg result = null;
        if (scheme.equals(SchemeType.TCP)) {
            result = new TCPConnectorCfg(config);
        } else if (scheme.equals(SchemeType.TCPS)) {
            result = new TCPSConnectorCfg(config);
        } else if (scheme.equals(SchemeType.RMI)) {
            result = new RMIConnectorCfg(config);
        } else if (scheme.equals(SchemeType.HTTP)) {
            result = new HTTPConnectorCfg(config);
        } else if (scheme.equals(SchemeType.HTTPS)) {
            result = new HTTPSConnectorCfg(config);
        } else if (scheme.equals(SchemeType.EMBEDDED)) {
            result = new VMConnectorCfg(config);
        }
        return result;
    }
}

