/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.net;

import java.rmi.RemoteException;
import java.util.List;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.net.orb.ORB;
import org.exolab.jms.net.orb.UnicastObject;
import org.exolab.jms.server.ServerSession;
import org.exolab.jms.server.net.RemoteServerConnection;

public class RemoteServerSession
extends UnicastObject
implements ServerSession {
    private RemoteServerConnection _connection;
    private ServerSession _session;

    public RemoteServerSession(ORB orb, RemoteServerConnection connection, ServerSession session) throws RemoteException {
        super(orb, null, true);
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Argument 'session' is null");
        }
        this._connection = connection;
        this._session = session;
    }

    public synchronized void close() throws JMSException {
        if (this._session != null) {
            try {
                this._session.close();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    try {
                        this.unexportObject();
                    }
                    catch (RemoteException exception) {
                        JMSException error = new JMSException(exception.getMessage());
                        error.setLinkedException((Exception)exception);
                        throw error;
                    }
                    Object var6_5 = null;
                    this._connection.closed(this);
                    this._connection = null;
                    this._session = null;
                }
                catch (Throwable throwable2) {
                    Object var6_6 = null;
                    this._connection.closed(this);
                    this._connection = null;
                    this._session = null;
                    throw throwable2;
                }
                throw throwable;
            }
            try {
                try {
                    this.unexportObject();
                }
                catch (RemoteException exception) {
                    JMSException error = new JMSException(exception.getMessage());
                    error.setLinkedException((Exception)exception);
                    throw error;
                }
                Object var6_3 = null;
                this._connection.closed(this);
                this._connection = null;
                this._session = null;
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                this._connection.closed(this);
                this._connection = null;
                this._session = null;
                throw throwable;
            }
        }
    }

    public void acknowledgeMessage(long consumerId, String messageId) throws JMSException {
        this._session.acknowledgeMessage(consumerId, messageId);
    }

    public void send(MessageImpl message) throws JMSException {
        this._session.send(message);
    }

    public void send(List messages) throws JMSException {
        this._session.send(messages);
    }

    public MessageImpl receiveNoWait(long consumerId) throws JMSException {
        return this._session.receiveNoWait(consumerId);
    }

    public MessageImpl receive(long consumerId, long wait) throws JMSException {
        return this._session.receive(consumerId, wait);
    }

    public List browse(long consumerId, int count) throws JMSException {
        return this._session.browse(consumerId, count);
    }

    public long createConsumer(JmsDestination destination, String selector, boolean noLocal) throws JMSException {
        return this._session.createConsumer(destination, selector, noLocal);
    }

    public long createDurableConsumer(JmsTopic topic, String name, String selector, boolean noLocal) throws JMSException {
        return this._session.createDurableConsumer(topic, name, selector, noLocal);
    }

    public long createBrowser(JmsQueue queue, String selector) throws JMSException {
        return this._session.createBrowser(queue, selector);
    }

    public void closeConsumer(long consumerId) throws JMSException {
        this._session.closeConsumer(consumerId);
    }

    public void unsubscribe(String name) throws JMSException {
        this._session.unsubscribe(name);
    }

    public void start() throws JMSException {
        this._session.start();
    }

    public void stop() throws JMSException {
        this._session.stop();
    }

    public void setMessageListener(JmsMessageListener listener) {
        this._session.setMessageListener(listener);
    }

    public void setAsynchronous(long consumerId, boolean enable) throws JMSException {
        this._session.setAsynchronous(consumerId, enable);
    }

    public void recover() throws JMSException {
        this._session.recover();
    }

    public void commit() throws JMSException {
        this._session.commit();
    }

    public void rollback() throws JMSException {
        this._session.rollback();
    }

    public void start(Xid xid, int flags) throws XAException {
        this._session.start(xid, flags);
    }

    public int prepare(Xid xid) throws XAException {
        return this._session.prepare(xid);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this._session.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        this._session.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        this._session.forget(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this._session.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this._session.rollback(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this._session.getTransactionTimeout();
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this._session.setTransactionTimeout(seconds);
    }

    public String getResourceManagerId() throws XAException {
        return this._session.getResourceManagerId();
    }
}

