/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.net;

import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.TcpsConfiguration;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.socket.SocketRequestInfo;
import org.exolab.jms.net.tcp.TCPSRequestInfo;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.util.Properties;
import org.exolab.jms.net.util.SSLProperties;
import org.exolab.jms.server.net.AbstractTCPConnectorCfg;

class TCPSConnectorCfg
extends AbstractTCPConnectorCfg {
    public TCPSConnectorCfg(Configuration config) {
        super(SchemeType.TCPS, config, config.getTcpsConfiguration());
    }

    protected void populateAcceptProperties(Properties properties) {
        TCPSRequestInfo info;
        URI uri = this.getURI(this.getExportURI());
        try {
            info = new TCPSRequestInfo(uri);
        }
        catch (ResourceException exception) {
            throw new IllegalStateException(exception.getMessage());
        }
        this.populateRequestInfo((SocketRequestInfo)info);
        TcpsConfiguration config = this.getConfiguration().getTcpsConfiguration();
        SSLProperties ssl = new SSLProperties();
        ssl.setKeyStore(config.getKeyStore());
        ssl.setKeyStorePassword(config.getKeyStorePassword());
        ssl.setKeyStoreType(config.getKeyStoreType());
        ssl.setTrustStore(config.getTrustStore());
        ssl.setTrustStorePassword(config.getTrustStorePassword());
        ssl.setTrustStoreType(config.getTrustStoreType());
        if (!ssl.isEmpty()) {
            info.setSSLProperties(ssl);
        }
        info.setNeedClientAuth(config.getNeedClientAuth());
        info.export(properties);
    }
}

