/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.service;

import org.exolab.jms.service.ServiceException;
import org.exolab.jms.service.Serviceable;

public abstract class Service
implements Serviceable {
    private final String _name;
    private volatile boolean _started = false;

    public Service() {
        this(null);
    }

    protected Service(String name) {
        this._name = name;
    }

    public void start() throws ServiceException {
        if (this._started) {
            throw new ServiceException("Service already started");
        }
        this.doStart();
        this._started = true;
    }

    public void stop() throws ServiceException {
        if (!this._started) {
            throw new ServiceException("Service not started");
        }
        this.doStop();
        this._started = false;
    }

    public void restart() throws ServiceException {
        if (this._started) {
            this.stop();
        }
        this.start();
    }

    public boolean isStarted() {
        return this._started;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Service:[");
        buf.append("name=");
        buf.append(this._name);
        buf.append("started=");
        buf.append(this._started);
        buf.append("]");
        return buf.toString();
    }

    protected void doStart() throws ServiceException {
    }

    protected void doStop() throws ServiceException {
    }
}

