/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.service;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exolab.jms.service.Service;
import org.exolab.jms.service.ServiceAlreadyExistsException;
import org.exolab.jms.service.ServiceDoesNotExistException;
import org.exolab.jms.service.ServiceException;
import org.exolab.jms.service.Serviceable;
import org.exolab.jms.service.Services;

public class ServiceManager
extends Service
implements Services {
    private final Map _services = new HashMap();
    private final List _addOrder = new ArrayList();
    private final List _createOrder = new ArrayList();
    static /* synthetic */ Class class$org$exolab$jms$service$Services;

    public ServiceManager() {
        this._services.put(class$org$exolab$jms$service$Services == null ? (class$org$exolab$jms$service$Services = ServiceManager.class$("org.exolab.jms.service.Services")) : class$org$exolab$jms$service$Services, this);
    }

    public synchronized void addService(Class type) throws ServiceException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' is null");
        }
        this.checkExists(type);
        this._services.put(type, null);
        this._addOrder.add(type);
    }

    public void addService(Object service) throws ServiceException {
        if (service == null) {
            throw new IllegalArgumentException("Argument 'service' is null");
        }
        Class<?> type = service.getClass();
        this.checkExists(type);
        this._services.put(type, service);
        this._addOrder.add(type);
    }

    public synchronized Object getService(Class type) throws ServiceException {
        LinkedList creating = new LinkedList();
        ArrayList created = new ArrayList();
        Object service = this.getService(type, creating, created);
        Iterator iterator = created.iterator();
        while (iterator.hasNext()) {
            this.invokeSetters(iterator.next());
        }
        return service;
    }

    protected void doStart() throws ServiceException {
        Iterator iter = this._addOrder.iterator();
        while (iter.hasNext()) {
            Class type = (Class)iter.next();
            this.getService(type);
        }
        Iterator iter2 = this._createOrder.iterator();
        while (iter2.hasNext()) {
            Class type = (Class)iter2.next();
            Object service = this.getService(type);
            if (!(service instanceof Serviceable)) continue;
            ((Serviceable)service).start();
        }
    }

    protected void doStop() throws ServiceException {
        Iterator iter = this._createOrder.iterator();
        while (iter.hasNext()) {
            Class type = (Class)iter.next();
            Object service = this.getService(type);
            if (!(service instanceof Serviceable)) continue;
            ((Serviceable)service).stop();
        }
    }

    private Object getService(Class type, LinkedList creating, List created) throws ServiceException {
        Iterator types = this._services.keySet().iterator();
        ArrayList<Class> matches = new ArrayList<Class>();
        while (types.hasNext()) {
            Class clazz = (Class)types.next();
            if (!type.isAssignableFrom(clazz)) continue;
            matches.add(clazz);
        }
        if (matches.isEmpty()) {
            String msg = "Service of type " + type.getName() + " not registered";
            Class requiredBy = null;
            if (!creating.isEmpty()) {
                requiredBy = (Class)creating.getLast();
                msg = msg + ", but required by " + requiredBy.getName();
            }
            throw new ServiceDoesNotExistException(msg);
        }
        if (matches.size() > 1) {
            throw new ServiceException("Multiple services match service type " + type.getName());
        }
        Class match = (Class)matches.get(0);
        Object service = this._services.get(match);
        if (service == null) {
            service = this.createService(match, creating, created);
            this._services.put(match, service);
            this._createOrder.add(match);
        }
        return service;
    }

    protected Object createService(Class type, LinkedList creating, List created) throws ServiceException {
        Object service;
        if (creating.contains(type)) {
            throw new ServiceException("Circular dependency trying to construct " + type.getName() + ": " + creating);
        }
        Constructor<?>[] constructors = type.getConstructors();
        if (constructors.length > 1) {
            throw new ServiceException("Cannot create service of type " + type.getName() + ": multiple public constructors");
        }
        if (constructors.length != 1) {
            throw new ServiceException("Cannot create service of type " + type.getName() + ": no public constructor");
        }
        Constructor<?> ctor = constructors[0];
        Class<?>[] types = ctor.getParameterTypes();
        Object[] args = new Object[types.length];
        try {
            try {
                creating.add(type);
                int i = 0;
                while (i < types.length) {
                    args[i] = this.getService(types[i], creating, created);
                    ++i;
                }
                service = ctor.newInstance(args);
                created.add(service);
            }
            catch (IllegalAccessException exception) {
                throw new ServiceException("Failed to create service of type: " + type, exception);
            }
            catch (InvocationTargetException exception) {
                Throwable target = exception.getTargetException();
                if (target == null) {
                    target = exception;
                }
                throw new ServiceException("Failed to create service of type: " + type, target);
            }
            catch (InstantiationException exception) {
                throw new ServiceException("Failed to create service of type: " + type, exception);
            }
            Object var13_11 = null;
            creating.remove(type);
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            creating.remove(type);
            throw throwable;
        }
        return service;
    }

    private void invokeSetters(Object service) throws ServiceException {
        PropertyDescriptor[] descriptors;
        try {
            BeanInfo info = Introspector.getBeanInfo(service.getClass());
            descriptors = info.getPropertyDescriptors();
        }
        catch (IntrospectionException exception) {
            throw new ServiceException(exception.getMessage(), exception);
        }
        int i = 0;
        while (i < descriptors.length) {
            PropertyDescriptor descriptor = descriptors[i];
            Method method = descriptor.getWriteMethod();
            if (method != null) {
                Class<?> type = descriptor.getPropertyType();
                Object[] args = new Object[]{this.getService(type)};
                try {
                    method.invoke(service, args);
                }
                catch (IllegalAccessException exception) {
                    throw new ServiceException("Failed to create service of type: " + type, exception);
                }
                catch (InvocationTargetException exception) {
                    Throwable target = exception.getTargetException();
                    if (target == null) {
                        target = exception;
                    }
                    throw new ServiceException("Failed to create service of type: " + type, target);
                }
            }
            ++i;
        }
    }

    protected void checkExists(Class type) throws ServiceAlreadyExistsException {
        if (this._services.get(type) != null) {
            throw new ServiceAlreadyExistsException("Service of type " + type + " already registered");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

