/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tranlog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.transaction.xa.Xid;

public final class ExternalXid
implements Xid,
Externalizable {
    static final long serialVersionUID = 1L;
    protected static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private int _formatId;
    private byte[] _global;
    private byte[] _branch;
    private transient String _string = null;

    public ExternalXid() {
    }

    public ExternalXid(Xid xid) {
        this(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    public ExternalXid(int formatId, byte[] global, byte[] branch) {
        this._formatId = formatId;
        if (global == null || global.length == 0) {
            this._global = new byte[0];
        } else {
            this._global = new byte[global.length];
            System.arraycopy(global, 0, this._global, 0, global.length);
        }
        if (branch == null || branch.length == 0) {
            this._branch = new byte[0];
        } else {
            this._branch = new byte[branch.length];
            System.arraycopy(branch, 0, this._branch, 0, branch.length);
        }
    }

    public int getFormatId() {
        return this._formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this._global;
    }

    public byte[] getBranchQualifier() {
        return this._branch;
    }

    public String toString() {
        if (this._string == null) {
            int i;
            StringBuffer buffer = new StringBuffer("xid://");
            buffer.append(HEX_DIGITS[this._formatId >> 28 & 0xF]);
            buffer.append(HEX_DIGITS[this._formatId >> 24 & 0xF]);
            buffer.append(HEX_DIGITS[this._formatId >> 20 & 0xF]);
            buffer.append(HEX_DIGITS[this._formatId >> 16 & 0xF]);
            buffer.append(HEX_DIGITS[this._formatId >> 12 & 0xF]);
            buffer.append(HEX_DIGITS[this._formatId >> 8 & 0xF]);
            buffer.append(HEX_DIGITS[this._formatId >> 4 & 0xF]);
            buffer.append(HEX_DIGITS[this._formatId & 0xF]);
            buffer.append('-');
            if (this._global != null && this._global.length > 0) {
                i = this._global.length;
                while (i-- > 0) {
                    buffer.append(HEX_DIGITS[(this._global[i] & 0xF0) >> 4]);
                    buffer.append(HEX_DIGITS[this._global[i] & 0xF]);
                }
            }
            buffer.append('-');
            if (this._branch != null && this._branch.length > 0) {
                i = this._branch.length;
                while (i-- > 0) {
                    buffer.append(HEX_DIGITS[(this._branch[i] & 0xF0) >> 4]);
                    buffer.append(HEX_DIGITS[this._branch[i] & 0xF]);
                }
            }
            this._string = buffer.toString();
        }
        return this._string;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ExternalXid) {
            byte[] branch;
            Xid xid = (Xid)obj;
            if (xid.getFormatId() != this._formatId) {
                return false;
            }
            byte[] global = xid.getGlobalTransactionId();
            if (global == null || global.length == 0) {
                if (this._global != null || this._global.length != 0) {
                    return false;
                }
            } else {
                if (global.length != this._global.length) {
                    return false;
                }
                int index = 0;
                while (index < global.length) {
                    if (global[index] != this._global[index]) {
                        return false;
                    }
                    ++index;
                }
            }
            if ((branch = xid.getBranchQualifier()) == null || branch.length == 0) {
                if (this._branch != null || this._branch.length != 0) {
                    return false;
                }
            } else {
                if (branch.length != this._branch.length) {
                    return false;
                }
                int index = 0;
                while (index < branch.length) {
                    if (branch[index] != this._branch[index]) {
                        return false;
                    }
                    ++index;
                }
            }
            return true;
        }
        return false;
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(1L);
        stream.writeInt(this._formatId);
        stream.writeInt(this._global.length);
        stream.write(this._global);
        stream.writeInt(this._branch.length);
        stream.write(this._branch);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version != 1L) {
            throw new IOException("No support for ExternalXid with version " + version);
        }
        this._formatId = stream.readInt();
        this._global = new byte[stream.readInt()];
        stream.read(this._global);
        this._branch = new byte[stream.readInt()];
        stream.read(this._branch);
    }
}

