/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tranlog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class TransactionState
implements Externalizable {
    static final long serialVersionUID = 1L;
    private String _state;
    private int _ord;
    public static final int OPENED_ORD = 1;
    public static final int PREPARED_ORD = 2;
    public static final int CLOSED_ORD = 3;
    public static final TransactionState OPENED = new TransactionState("opened", 1);
    public static final TransactionState PREPARED = new TransactionState("prepared", 2);
    public static final TransactionState CLOSED = new TransactionState("closed", 3);

    public TransactionState() {
    }

    private TransactionState(String state, int ord) {
        this._state = state;
        this._ord = ord;
    }

    public int getOrd() {
        return this._ord;
    }

    public String toString() {
        return this._state;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof TransactionState && ((TransactionState)obj).getOrd() == this.getOrd()) {
            result = true;
        }
        return result;
    }

    public boolean isOpened() {
        return this._ord == OPENED.getOrd();
    }

    public boolean isPrepared() {
        return this._ord == PREPARED.getOrd();
    }

    public boolean isClosed() {
        return this._ord == CLOSED.getOrd();
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(1L);
        stream.writeObject(this._state);
        stream.writeInt(this._ord);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version != 1L) {
            throw new IOException("No support for TransactionState with version " + version);
        }
        this._state = (String)stream.readObject();
        this._ord = stream.readInt();
    }
}

