/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.jndikit;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.ResolveResult;
import org.codehaus.spice.jndikit.AbstractContext;

public abstract class AbstractURLContext
extends AbstractContext
implements NameParser {
    private final String m_scheme;

    public AbstractURLContext(String scheme, Hashtable environment) {
        super(environment);
        this.m_scheme = scheme;
    }

    public Name parse(String name) throws NamingException {
        return new CompositeName().add(name);
    }

    protected NameParser getNameParser() throws NamingException {
        return this;
    }

    protected void bind(Name name, Object object, boolean rebind) throws NamingException {
        ResolveResult resolveResult = this.getBaseURLContext(name, this.getRawEnvironment());
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            if (rebind) {
                context.rebind(resolveResult.getRemainingName(), object);
            } else {
                context.bind(resolveResult.getRemainingName(), object);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            context.close();
            throw throwable;
        }
        context.close();
    }

    public Context createSubcontext(Name name) throws NamingException {
        Context context;
        ResolveResult resolveResult = this.getBaseURLContext(name, this.getRawEnvironment());
        Context context2 = (Context)resolveResult.getResolvedObj();
        try {
            context = context2.createSubcontext(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context2.close();
            throw throwable;
        }
        context2.close();
        return context;
    }

    public void destroySubcontext(Name name) throws NamingException {
        ResolveResult resolveResult = this.getBaseURLContext(name, this.getRawEnvironment());
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.destroySubcontext(resolveResult.getRemainingName());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.close();
            throw throwable;
        }
        context.close();
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public NamingEnumeration list(Name name) throws NamingException {
        NamingEnumeration<NameClassPair> namingEnumeration;
        ResolveResult resolveResult = this.getBaseURLContext(name, this.getRawEnvironment());
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            namingEnumeration = context.list(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return namingEnumeration;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        NamingEnumeration<Binding> namingEnumeration;
        ResolveResult resolveResult = this.getBaseURLContext(name, this.getRawEnvironment());
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            namingEnumeration = context.listBindings(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return namingEnumeration;
    }

    public Object lookup(Name name) throws NamingException {
        Object object;
        ResolveResult resolveResult = this.getBaseURLContext(name, this.getRawEnvironment());
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            object = context.lookup(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return object;
    }

    public void unbind(Name name) throws NamingException {
        ResolveResult resolveResult = this.getBaseURLContext(name, this.getRawEnvironment());
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.unbind(resolveResult.getRemainingName());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.close();
            throw throwable;
        }
        context.close();
    }

    protected ResolveResult getBaseURLContext(Name name, Hashtable environment) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Unable to locate URLContext will empty name");
        }
        String nameString = name.get(0).toString();
        int index = nameString.indexOf(58);
        if (-1 == index) {
            String explanation = "Unable to build URLContext as it does not specify scheme";
            throw new InvalidNameException("Unable to build URLContext as it does not specify scheme");
        }
        String scheme = nameString.substring(0, index);
        int end = this.getEndIndexOfURLPart(nameString, index + 1);
        String urlPart = nameString.substring(index + 1, end);
        String namePart = nameString.substring(end);
        if (!this.m_scheme.equals(scheme)) {
            String explanation = "Bad Scheme use to build URLContext (" + scheme + "). " + "Expected " + this.m_scheme;
            throw new InvalidNameException(explanation);
        }
        Context context = this.newContext(urlPart);
        return new ResolveResult((Object)context, new CompositeName(namePart));
    }

    protected int getEndIndexOfURLPart(String name, int index) throws NamingException {
        int result = 0;
        if (name.startsWith("//", index)) {
            int end = name.indexOf("/", index + 2);
            result = -1 != end ? end : name.length();
        }
        return result;
    }

    protected abstract Context newContext(String var1) throws NamingException;
}

