/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.jndikit.memory;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.codehaus.spice.jndikit.AbstractNamingEnumeration;
import org.codehaus.spice.jndikit.Namespace;

final class MemoryNamingEnumeration
extends AbstractNamingEnumeration {
    protected Hashtable m_bindings;
    protected Iterator m_names;
    protected boolean m_returnBindings;

    public MemoryNamingEnumeration(Context owner, Namespace namespace, Hashtable bindings, boolean returnBindings) {
        super(owner, namespace);
        this.m_returnBindings = returnBindings;
        this.m_bindings = bindings;
        this.m_names = this.m_bindings.keySet().iterator();
    }

    public boolean hasMoreElements() {
        return this.m_names.hasNext();
    }

    public Object next() throws NamingException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        String name = (String)this.m_names.next();
        Object object = this.m_bindings.get(name);
        if (!this.m_returnBindings) {
            return new NameClassPair(name, object.getClass().getName());
        }
        return new Binding(name, this.resolve(name, object));
    }

    public void close() {
        super.close();
        this.m_bindings = null;
    }
}

