/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.common.threads;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronousChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.common.threads.ThreadFactory;
import org.exolab.jms.common.threads.ThreadListener;

public class ThreadPool
extends PooledExecutor {
    private ThreadListener _listener;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$common$threads$ThreadPool == null ? (class$org$exolab$jms$common$threads$ThreadPool = ThreadPool.class$("org.exolab.jms.common.threads.ThreadPool")) : class$org$exolab$jms$common$threads$ThreadPool));
    static /* synthetic */ Class class$org$exolab$jms$common$threads$ThreadPool;

    public ThreadPool(String name, int maxPoolSize) {
        this(name, maxPoolSize, false);
    }

    public ThreadPool(String name, Channel channel, int maxPoolSize) {
        this(name, channel, maxPoolSize, false);
    }

    public ThreadPool(String name, int maxPoolSize, boolean daemon) {
        this(new ThreadGroup(name), name, (Channel)new SynchronousChannel(), maxPoolSize, daemon);
    }

    public ThreadPool(String name, Channel channel, int maxPoolSize, boolean daemon) {
        this(new ThreadGroup(name), name, channel, maxPoolSize, daemon);
    }

    public ThreadPool(ThreadGroup group, String name, int maxPoolSize) {
        this(group, name, (Channel)new SynchronousChannel(), maxPoolSize, false);
    }

    public ThreadPool(ThreadGroup group, String name, Channel channel, int maxPoolSize, boolean daemon) {
        super(channel, maxPoolSize);
        this.setThreadFactory(new ThreadFactory(group, name + "-Worker-", daemon));
    }

    public void setThreadListener(ThreadListener listener) {
        this._listener = listener;
    }

    public void execute(Runnable command) throws InterruptedException {
        ThreadListener listener = this._listener;
        if (listener != null) {
            super.execute((Runnable)new NotifyingRunnable(command, listener));
        } else {
            super.execute(command);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class NotifyingRunnable
    implements Runnable {
        private final Runnable _command;
        private final ThreadListener _listener;

        public NotifyingRunnable(Runnable command, ThreadListener listener) {
            this._command = command;
            this._listener = listener;
        }

        public void run() {
            try {
                this._listener.begin(this._command);
            }
            catch (Throwable exception) {
                _log.error((Object)exception, exception);
            }
            this._command.run();
            try {
                this._listener.end(this._command);
            }
            catch (Throwable exception) {
                _log.error((Object)exception, exception);
            }
        }
    }
}

