/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.common.uuid;

import java.util.HashSet;
import java.util.Random;
import org.exolab.jms.common.uuid.Clock;

public final class UUIDGenerator {
    public static final int RESOLUTION_BYTES = 16;
    public static final int MAXIMUM_LENGTH = 64;
    public static final int MAXIMUM_PREFIX = 28;
    private static final int UUID_VARIANT_OCTET = 8;
    private static final int UUID_VARIANT_BYTE = 128;
    private static final int UUID_VERSION_CLOCK_OCTET = 1;
    private static final int UUID_VERSION_CLOCK_BYTE = 16;
    private static final int UUID_VERSION_NAME_OCTET = 3;
    private static final int UUID_VERSION_NAME_BYTE = 48;
    private static final int UUID_VERSION_RANDOM_CLOCK = 4;
    private static final int UUID_VERSION_RANDOM_BYTE = 64;
    private static final long JAVA_UUID_CLOCK_DIFF = 12219292800000L;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static int _uuidsPerTick;
    private static int _uuidsThisTick;
    private static long _lastClock;
    private static char[] _clockSeqOctet;
    private static byte[] _clockSeqByte;
    private static char[] _nodeIdentifierOctet;
    private static byte[] _nodeIdentifierByte;
    static /* synthetic */ Class class$org$exolab$jms$common$uuid$UUID;
    static /* synthetic */ Class class$org$exolab$jms$common$uuid$UUIDGenerator;

    public static String create() {
        return String.valueOf(UUIDGenerator.createTimeUUIDChars());
    }

    public static String create(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 'prefix' is null");
        }
        StringBuffer buffer = new StringBuffer(36 + prefix.length());
        buffer.append(prefix);
        buffer.append(UUIDGenerator.createTimeUUIDChars());
        return buffer.toString();
    }

    public static byte[] createBinary() {
        return UUIDGenerator.createTimeUUIDBytes();
    }

    public static byte[] toBytes(String prefix, String identifier) throws InvalidIDException {
        if (identifier == null) {
            throw new IllegalArgumentException("Argument identifier is null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument prefix is null");
        }
        if (!identifier.startsWith(prefix)) {
            throw new InvalidIDException("Invalid identifier: expected prefix " + prefix + "in identifier " + identifier);
        }
        int index = 0;
        byte[] bytes = new byte[(identifier.length() - prefix.length()) / 2];
        int i = prefix.length();
        while (i < identifier.length()) {
            char digit = identifier.charAt(i);
            if (digit != '-') {
                byte nibble;
                if (digit >= '0' && digit <= '9') {
                    nibble = (byte)(digit - 48 << 4);
                } else if (digit >= 'A' && digit <= 'F') {
                    nibble = (byte)(digit - 55 << 4);
                } else if (digit >= 'a' && digit <= 'f') {
                    nibble = (byte)(digit - 87 << 4);
                } else {
                    throw new InvalidIDException("character " + String.valueOf(digit) + " encountered, expected hexadecimal digit in identifier " + identifier);
                }
                if (++i == identifier.length()) {
                    throw new InvalidIDException("Invalid identifier: odd number of hexadecimal digits in identifier " + identifier);
                }
                digit = identifier.charAt(i);
                if (digit >= '0' && digit <= '9') {
                    nibble = (byte)(nibble | digit - 48);
                } else if (digit >= 'A' && digit <= 'F') {
                    nibble = (byte)(nibble | digit - 55);
                } else if (digit >= 'a' && digit <= 'f') {
                    nibble = (byte)(nibble | digit - 87);
                } else {
                    throw new InvalidIDException("character " + String.valueOf(digit) + " encountered, expected hexadecimal digit in identifier " + identifier);
                }
                bytes[index] = nibble;
                ++index;
            }
            ++i;
        }
        if (index == bytes.length) {
            return bytes;
        }
        byte[] newBytes = new byte[index];
        while (index-- > 0) {
            newBytes[index] = bytes[index];
        }
        return newBytes;
    }

    public static byte[] toBytes(String identifier) throws InvalidIDException {
        if (identifier == null) {
            throw new IllegalArgumentException("Argument identifier is null");
        }
        int index = 0;
        byte[] bytes = new byte[identifier.length() / 2];
        int i = 0;
        while (i < identifier.length()) {
            char digit = identifier.charAt(i);
            if (digit != '-') {
                byte nibble;
                if (digit >= '0' && digit <= '9') {
                    nibble = (byte)(digit - 48 << 4);
                } else if (digit >= 'A' && digit <= 'F') {
                    nibble = (byte)(digit - 55 << 4);
                } else if (digit >= 'a' && digit <= 'f') {
                    nibble = (byte)(digit - 87 << 4);
                } else {
                    throw new InvalidIDException("character " + String.valueOf(digit) + " encountered, expected hexadecimal digit in identifier " + identifier);
                }
                if (++i == identifier.length()) {
                    throw new InvalidIDException("Invalid identifier: odd number of hexadecimal digits in identifier " + identifier);
                }
                digit = identifier.charAt(i);
                if (digit >= '0' && digit <= '9') {
                    nibble = (byte)(nibble | digit - 48);
                } else if (digit >= 'A' && digit <= 'F') {
                    nibble = (byte)(nibble | digit - 55);
                } else if (digit >= 'a' && digit <= 'f') {
                    nibble = (byte)(nibble | digit - 87);
                } else {
                    throw new InvalidIDException("character " + String.valueOf(digit) + " encountered, expected hexadecimal digit in identifier " + identifier);
                }
                bytes[index] = nibble;
                ++index;
            }
            ++i;
        }
        if (index == bytes.length) {
            return bytes;
        }
        byte[] newBytes = new byte[index];
        while (index-- > 0) {
            newBytes[index] = bytes[index];
        }
        return newBytes;
    }

    public static String fromBytes(String prefix, byte[] bytes) {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument prefix is null");
        }
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("Argument bytes is null or an empty array");
        }
        StringBuffer buffer = new StringBuffer(prefix);
        int i = 0;
        while (i < bytes.length) {
            buffer.append(HEX_DIGITS[(bytes[i] & 0xF0) >> 4]);
            buffer.append(HEX_DIGITS[bytes[i] & 0xF]);
            ++i;
        }
        return buffer.toString();
    }

    public static String fromBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("Argument bytes is null or an empty array");
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            buffer.append(HEX_DIGITS[(bytes[i] & 0xF0) >> 4]);
            buffer.append(HEX_DIGITS[bytes[i] & 0xF]);
            ++i;
        }
        return buffer.toString();
    }

    public static String trim(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Argument identifier is null");
        }
        if (identifier.length() > 64) {
            return identifier.substring(0, 64);
        }
        return identifier;
    }

    /*
     * Unable to fully structure code
     */
    public static char[] createTimeUUIDChars() {
        var5 = UUIDGenerator.class$org$exolab$jms$common$uuid$UUID == null ? (UUIDGenerator.class$org$exolab$jms$common$uuid$UUID = UUIDGenerator.class$("org.exolab.jms.common.uuid.UUID")) : UUIDGenerator.class$org$exolab$jms$common$uuid$UUID;
        synchronized (var5) {
            clock = Clock.clock();
            block5: while (true) {
                if (clock > UUIDGenerator._lastClock) {
                    nextClock = UUIDGenerator._lastClock + (long)(UUIDGenerator._uuidsThisTick / 100);
                    if (clock <= nextClock) {
                        clock = Clock.synchronize();
                    }
                    if (clock > nextClock) {
                        UUIDGenerator._uuidsThisTick = 0;
                        UUIDGenerator._lastClock = clock;
                        UUIDGenerator._uuidsPerTick = Clock.getUnsynchTicks() * 100;
                        break;
                    }
                }
                if (UUIDGenerator._uuidsThisTick + 1 < UUIDGenerator._uuidsPerTick) {
                    ++UUIDGenerator._uuidsThisTick;
                    break;
                }
                clock = Clock.synchronize();
                if (clock > UUIDGenerator._lastClock) continue;
                while (true) {
                    if (clock <= UUIDGenerator._lastClock) ** break;
                    continue block5;
                    try {
                        Thread.currentThread();
                        Thread.sleep(Clock.getUnsynchTicks());
                    }
                    catch (InterruptedException except) {
                        // empty catch block
                    }
                    clock = Clock.synchronize();
                }
                break;
            }
            clock = (UUIDGenerator._lastClock + 12219292800000L) * 100L + (long)UUIDGenerator._uuidsThisTick;
            chars = new char[]{UUIDGenerator.HEX_DIGITS[(int)(clock >> 28 & 15L)], UUIDGenerator.HEX_DIGITS[(int)(clock >> 24 & 15L)], UUIDGenerator.HEX_DIGITS[(int)(clock >> 20 & 15L)], UUIDGenerator.HEX_DIGITS[(int)(clock >> 16 & 15L)], UUIDGenerator.HEX_DIGITS[(int)(clock >> 12 & 15L)], UUIDGenerator.HEX_DIGITS[(int)(clock >> 8 & 15L)], UUIDGenerator.HEX_DIGITS[(int)(clock >> 4 & 15L)], UUIDGenerator.HEX_DIGITS[(int)(clock & 15L)], '-', UUIDGenerator.HEX_DIGITS[(int)(clock >> 44 & 15L)], UUIDGenerator.HEX_DIGITS[(int)(clock >> 40 & 15L)], UUIDGenerator.HEX_DIGITS[(int)(clock >> 36 & 15L)], UUIDGenerator.HEX_DIGITS[(int)(clock >> 32 & 15L)], '-', UUIDGenerator.HEX_DIGITS[(int)(clock >> 60 & 15L | 1L)], UUIDGenerator.HEX_DIGITS[(int)(clock >> 56 & 15L)], UUIDGenerator.HEX_DIGITS[(int)(clock >> 52 & 15L)], UUIDGenerator.HEX_DIGITS[(int)(clock >> 48 & 15L)], '-', UUIDGenerator._clockSeqOctet[0], UUIDGenerator._clockSeqOctet[1], UUIDGenerator._clockSeqOctet[2], UUIDGenerator._clockSeqOctet[3], '-', UUIDGenerator._nodeIdentifierOctet[0], UUIDGenerator._nodeIdentifierOctet[1], UUIDGenerator._nodeIdentifierOctet[2], UUIDGenerator._nodeIdentifierOctet[3], UUIDGenerator._nodeIdentifierOctet[4], UUIDGenerator._nodeIdentifierOctet[5], UUIDGenerator._nodeIdentifierOctet[6], UUIDGenerator._nodeIdentifierOctet[7], UUIDGenerator._nodeIdentifierOctet[8], UUIDGenerator._nodeIdentifierOctet[9], UUIDGenerator._nodeIdentifierOctet[10], UUIDGenerator._nodeIdentifierOctet[11]};
        }
        return chars;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] createTimeUUIDBytes() {
        var5 = UUIDGenerator.class$org$exolab$jms$common$uuid$UUIDGenerator == null ? (UUIDGenerator.class$org$exolab$jms$common$uuid$UUIDGenerator = UUIDGenerator.class$("org.exolab.jms.common.uuid.UUIDGenerator")) : UUIDGenerator.class$org$exolab$jms$common$uuid$UUIDGenerator;
        synchronized (var5) {
            clock = Clock.clock();
            block5: while (true) {
                if (clock > UUIDGenerator._lastClock) {
                    nextClock = UUIDGenerator._lastClock + (long)(UUIDGenerator._uuidsThisTick / 100);
                    if (clock <= nextClock) {
                        clock = Clock.synchronize();
                    }
                    if (clock > nextClock) {
                        UUIDGenerator._uuidsThisTick = 0;
                        UUIDGenerator._lastClock = clock;
                        UUIDGenerator._uuidsPerTick = Clock.getUnsynchTicks() * 100;
                        break;
                    }
                }
                if (UUIDGenerator._uuidsThisTick + 1 < UUIDGenerator._uuidsPerTick) {
                    ++UUIDGenerator._uuidsThisTick;
                    break;
                }
                clock = Clock.synchronize();
                if (clock > UUIDGenerator._lastClock) continue;
                while (true) {
                    if (clock <= UUIDGenerator._lastClock) ** break;
                    continue block5;
                    try {
                        Thread.currentThread();
                        Thread.sleep(Clock.getUnsynchTicks());
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    clock = Clock.synchronize();
                }
                break;
            }
            clock = (UUIDGenerator._lastClock + 12219292800000L) * 100L + (long)UUIDGenerator._uuidsThisTick;
            bytes = new byte[]{(byte)(clock >> 24 & 255L), (byte)(clock >> 16 & 255L), (byte)(clock >> 8 & 255L), (byte)(clock & 255L), (byte)(clock >> 40 & 255L), (byte)(clock >> 32 & 255L), (byte)(clock >> 60 & 255L | 16L), (byte)(clock >> 48 & 255L), UUIDGenerator._clockSeqByte[0], UUIDGenerator._clockSeqByte[1], UUIDGenerator._nodeIdentifierByte[0], UUIDGenerator._nodeIdentifierByte[1], UUIDGenerator._nodeIdentifierByte[2], UUIDGenerator._nodeIdentifierByte[3], UUIDGenerator._nodeIdentifierByte[4], UUIDGenerator._nodeIdentifierByte[5]};
        }
        return bytes;
    }

    public static boolean isLocal(byte[] uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Argument uuid is null");
        }
        if (uuid.length != 16) {
            return false;
        }
        return uuid[10] == _nodeIdentifierByte[0] && uuid[11] == _nodeIdentifierByte[1] && uuid[12] == _nodeIdentifierByte[2] && uuid[13] == _nodeIdentifierByte[3] && uuid[14] == _nodeIdentifierByte[4] && uuid[15] == _nodeIdentifierByte[5];
    }

    private static void initialize() {
        Random random = new Random();
        long nodeIdLong = random.nextLong();
        nodeIdLong |= 0x8000L;
        int seqInt = random.nextInt(4096);
        _clockSeqOctet = new char[4];
        UUIDGenerator._clockSeqOctet[0] = HEX_DIGITS[(seqInt &= 0x1FFF) >> 12 & 0xF];
        UUIDGenerator._clockSeqOctet[1] = HEX_DIGITS[seqInt >> 8 & 0xF];
        UUIDGenerator._clockSeqOctet[2] = HEX_DIGITS[seqInt >> 4 & 0xF];
        UUIDGenerator._clockSeqOctet[3] = HEX_DIGITS[seqInt & 0xF];
        _clockSeqByte = new byte[2];
        UUIDGenerator._clockSeqByte[0] = (byte)(seqInt >> 8 & 0xFF);
        UUIDGenerator._clockSeqByte[1] = (byte)(seqInt & 0xFF);
        UUIDGenerator._clockSeqOctet[0] = HEX_DIGITS[seqInt >> 12 & 0xF | 8];
        UUIDGenerator._clockSeqByte[0] = (byte)(seqInt >> 8 & 0xFF | 0x80);
        _nodeIdentifierOctet = new char[12];
        int i = 0;
        while (i < 12) {
            UUIDGenerator._nodeIdentifierOctet[i] = HEX_DIGITS[(int)(nodeIdLong >> (11 - i) * 4 & 0xFL)];
            ++i;
        }
        _nodeIdentifierByte = new byte[6];
        int i2 = 0;
        while (i2 < 6) {
            UUIDGenerator._nodeIdentifierByte[i2] = (byte)(nodeIdLong >> (5 - i2) * 8 & 0xFFL);
            ++i2;
        }
        _uuidsPerTick = Clock.getUnsynchTicks() * 100;
    }

    public static void main(String[] args) {
        int count = 1000000;
        int i = 0;
        while (i < 10) {
            System.out.println(UUIDGenerator.create());
            ++i;
        }
        long clock = System.currentTimeMillis();
        HashSet<String> hash = new HashSet<String>(count / 100, 100.0f);
        int i2 = 0;
        while (i2 < count) {
            String id;
            if (i2 % 10000 == 0) {
                System.out.println("Checked " + i2);
            }
            if (hash.contains(id = UUIDGenerator.create())) {
                System.out.println("Duplicate id " + id);
            } else {
                hash.add(id);
            }
            ++i2;
        }
        clock = System.currentTimeMillis() - clock;
        System.out.println("Generated " + count + " UUIDs in " + clock + "ms");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        UUIDGenerator.initialize();
        _uuidsThisTick = _uuidsPerTick;
        _lastClock = Clock.clock();
    }

    public static class InvalidIDException
    extends Exception {
        public InvalidIDException(String message) {
            super(message);
        }
    }
}

