/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Vector;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public final class JMethodSignature {
    private JModifiers modifiers = null;
    private JType returnType = null;
    private String name = null;
    private JNamedMap params = null;
    private JDocComment jdc = null;
    private Vector exceptions = null;

    public JMethodSignature(String name, JType returnType) {
        if (name == null || name.length() == 0) {
            String err = "The method name must not be null or zero-length";
            throw new IllegalArgumentException(err);
        }
        this.jdc = new JDocComment();
        this.returnType = returnType;
        this.name = name;
        this.modifiers = new JModifiers();
        this.params = new JNamedMap(3);
        this.exceptions = new Vector(1);
    }

    public void addException(JClass exp) {
        if (exp == null) {
            return;
        }
        String expClassName = exp.getName();
        int i = 0;
        while (i < this.exceptions.size()) {
            JClass jClass = (JClass)this.exceptions.elementAt(i);
            if (expClassName.equals(jClass.getName())) {
                return;
            }
            ++i;
        }
        this.exceptions.addElement(exp);
    }

    public void addParameter(JParameter parameter) throws IllegalArgumentException {
        if (parameter == null) {
            return;
        }
        String pName = parameter.getName();
        if (this.params.get(pName) != null) {
            StringBuffer err = new StringBuffer();
            err.append("A parameter already exists for this method, ");
            err.append(this.name);
            err.append(", with the name: ");
            err.append(pName);
            throw new IllegalArgumentException(err.toString());
        }
        this.params.put(pName, parameter);
        this.jdc.addDescriptor(JDocDescriptor.createParamDesc(pName, null));
    }

    public JClass[] getExceptions() {
        Object[] jclasses = new JClass[this.exceptions.size()];
        this.exceptions.copyInto(jclasses);
        return jclasses;
    }

    public JDocComment getJDocComment() {
        return this.jdc;
    }

    public JModifiers getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public JParameter getParameter(int index) {
        return (JParameter)this.params.get(index);
    }

    public synchronized JParameter[] getParameters() {
        JParameter[] pArray = new JParameter[this.params.size()];
        int i = 0;
        while (i < pArray.length) {
            pArray[i] = (JParameter)this.params.get(i);
            ++i;
        }
        return pArray;
    }

    public JType getReturnType() {
        return this.returnType;
    }

    public void setComment(String comment) {
        this.jdc.setComment(comment);
    }

    public void setModifiers(JModifiers modifiers) {
        this.modifiers = modifiers.copy();
        this.modifiers.setFinal(false);
    }

    public void print(JSourceWriter jsw) {
        this.print(jsw, true);
    }

    public void print(JSourceWriter jsw, boolean printJavaDoc) {
        if (printJavaDoc) {
            this.jdc.print(jsw);
        }
        jsw.write(this.modifiers.toString());
        if (this.modifiers.toString().length() > 0) {
            jsw.write(32);
        }
        if (this.returnType != null) {
            jsw.write(this.returnType);
        } else {
            jsw.write("void");
        }
        jsw.write(32);
        jsw.write(this.name);
        jsw.write(40);
        int i = 0;
        while (i < this.params.size()) {
            if (i > 0) {
                jsw.write(", ");
            }
            jsw.write(this.params.get(i));
            ++i;
        }
        jsw.write(")");
        if (this.exceptions.size() > 0) {
            jsw.writeln();
            jsw.write("    throws ");
            int i2 = 0;
            while (i2 < this.exceptions.size()) {
                if (i2 > 0) {
                    jsw.write(", ");
                }
                JClass jClass = (JClass)this.exceptions.elementAt(i2);
                jsw.write(jClass.getName());
                ++i2;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.returnType != null) {
            sb.append(this.returnType);
        } else {
            sb.append("void");
        }
        sb.append(' ');
        sb.append(this.name);
        sb.append('(');
        int i = 0;
        while (i < this.params.size()) {
            JParameter jParam = (JParameter)this.params.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(jParam.getType().getName());
            ++i;
        }
        sb.append(") ");
        return sb.toString();
    }

    protected String[] getParameterClassNames() {
        Vector<String> names = new Vector<String>(this.params.size());
        int i = 0;
        while (i < this.params.size()) {
            JType jType = ((JParameter)this.params.get(i)).getType();
            while (jType.isArray()) {
                jType = jType.getComponentType();
            }
            if (!jType.isPrimitive()) {
                JClass jclass = (JClass)jType;
                names.addElement(jclass.getName());
            }
            ++i;
        }
        Object[] names_array = new String[names.size()];
        names.copyInto(names_array);
        return names_array;
    }
}

