/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.connector;

import java.security.Principal;
import java.util.Map;
import org.exolab.jms.net.connector.Connection;
import org.exolab.jms.net.connector.ConnectionFactory;
import org.exolab.jms.net.connector.ConnectionManager;
import org.exolab.jms.net.connector.ConnectionRequestInfo;
import org.exolab.jms.net.connector.ManagedConnectionFactory;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;
import org.exolab.jms.net.util.Properties;

public abstract class AbstractConnectionFactory
implements ConnectionFactory {
    public static final String PROPERTY_PREFIX = "org.exolab.jms.net.";
    private final String _connectScheme;
    private final String _acceptScheme;
    private final ManagedConnectionFactory _factory;
    private final ConnectionManager _manager;

    public AbstractConnectionFactory(String scheme, ManagedConnectionFactory factory, ConnectionManager manager) {
        this(scheme, scheme, factory, manager);
    }

    public AbstractConnectionFactory(String connectScheme, String acceptScheme, ManagedConnectionFactory factory, ConnectionManager manager) {
        this._connectScheme = connectScheme;
        this._acceptScheme = acceptScheme;
        this._factory = factory;
        this._manager = manager;
    }

    public boolean canConnect(URI uri) {
        return this._connectScheme.equals(uri.getScheme());
    }

    public Connection getConnection(Principal principal, URI uri) throws ResourceException {
        return this.getConnection(principal, uri, null);
    }

    public Connection getConnection(Principal principal, URI uri, Map properties) throws ResourceException {
        ConnectionRequestInfo info = this.getConnectionRequestInfo(uri, properties);
        if (principal == null) {
            principal = URIHelper.getPrincipal(uri);
        }
        return this._manager.allocateConnection(this._factory, principal, info);
    }

    public boolean canAccept(URI uri) {
        return this._acceptScheme.equals(uri.getScheme());
    }

    public void accept(URI uri) throws ResourceException {
        this.accept(uri, null);
    }

    public void accept(URI uri, Map properties) throws ResourceException {
        ConnectionRequestInfo info = this.getAcceptorRequestInfo(uri, properties);
        this._manager.accept(this._factory, info);
    }

    protected abstract ConnectionRequestInfo getConnectionRequestInfo(URI var1, Map var2) throws ResourceException;

    protected ConnectionRequestInfo getAcceptorRequestInfo(URI uri, Map properties) throws ResourceException {
        return this.getConnectionRequestInfo(uri, properties);
    }

    protected ManagedConnectionFactory getManagedConnectionFactory() {
        return this._factory;
    }

    protected ConnectionManager getConnectionManager() {
        return this._manager;
    }

    protected Properties getProperties(Map properties) {
        String prefix = PROPERTY_PREFIX + this._connectScheme + ".";
        return new Properties(properties, prefix);
    }
}

