/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.connector;

import java.security.Principal;
import org.exolab.jms.net.connector.Connection;
import org.exolab.jms.net.connector.InvocationHandler;
import org.exolab.jms.net.connector.ManagedConnection;
import org.exolab.jms.net.connector.ManagedConnectionListener;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.uri.URI;

public abstract class AbstractManagedConnection
implements ManagedConnection {
    private ManagedConnectionListener _listener;

    public synchronized void setConnectionEventListener(ManagedConnectionListener listener) throws ResourceException {
        this._listener = listener;
    }

    protected void notifyClosed() {
        ManagedConnectionListener listener = this.getConnectionEventListener();
        if (listener != null) {
            listener.closed(this);
        }
    }

    protected void notifyError(Throwable error) {
        ManagedConnectionListener listener = this.getConnectionEventListener();
        if (listener != null) {
            listener.error(this, error);
        }
    }

    protected synchronized ManagedConnectionListener getConnectionEventListener() {
        return this._listener;
    }

    public abstract void destroy() throws ResourceException;

    public abstract Principal getPrincipal() throws ResourceException;

    public abstract URI getLocalURI() throws ResourceException;

    public abstract URI getRemoteURI() throws ResourceException;

    public abstract void ping() throws ResourceException;

    public abstract Connection getConnection() throws ResourceException;

    public abstract void setInvocationHandler(InvocationHandler var1) throws ResourceException;
}

