/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.connector;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.connector.Connection;
import org.exolab.jms.net.connector.ConnectionFactory;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.uri.URI;

public final class ConnectionContext {
    private static ThreadLocal _contexts = new ThreadLocal();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$connector$ConnectionContext == null ? (class$org$exolab$jms$net$connector$ConnectionContext = ConnectionContext.class$("org.exolab.jms.net.connector.ConnectionContext")) : class$org$exolab$jms$net$connector$ConnectionContext));
    static /* synthetic */ Class class$org$exolab$jms$net$connector$ConnectionContext;

    private ConnectionContext() {
    }

    public static void push(Principal principal, ConnectionFactory factory) {
        ArrayList<Context> stack = (ArrayList<Context>)_contexts.get();
        if (stack == null) {
            stack = new ArrayList<Context>(2);
            _contexts.set(stack);
        }
        stack.add(new Context(principal, factory));
    }

    public static void pop() {
        List stack = (List)_contexts.get();
        stack.remove(stack.size() - 1);
    }

    public static Connection getConnection(URI uri) {
        Connection result = null;
        Context context = ConnectionContext.top();
        if (context != null) {
            ConnectionFactory factory = context.getConnectionFactory();
            try {
                result = factory.getConnection(context.getPrincipal(), uri);
            }
            catch (ResourceException exception) {
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        return result;
    }

    public static ConnectionFactory getConnectionFactory() {
        ConnectionFactory result = null;
        Context context = ConnectionContext.top();
        if (context != null) {
            result = context.getConnectionFactory();
        }
        return result;
    }

    private static Context top() {
        Context context = null;
        List stack = (List)_contexts.get();
        if (stack != null && !stack.isEmpty()) {
            context = (Context)stack.get(stack.size() - 1);
        }
        return context;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Context {
        private final Principal _principal;
        private final ConnectionFactory _factory;

        public Context(Principal principal, ConnectionFactory factory) {
            this._principal = principal;
            this._factory = factory;
        }

        public Principal getPrincipal() {
            return this._principal;
        }

        public ConnectionFactory getConnectionFactory() {
            return this._factory;
        }
    }
}

