/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.connector;

import org.exolab.jms.net.connector.Caller;
import org.exolab.jms.net.connector.ConnectionContext;
import org.exolab.jms.net.connector.ConnectionFactory;
import org.exolab.jms.net.connector.Invocation;
import org.exolab.jms.net.connector.InvocationHandler;
import org.exolab.jms.net.connector.ManagedConnection;
import org.exolab.jms.net.connector.Request;
import org.exolab.jms.net.connector.Response;

public class ContextInvocationHandler
implements InvocationHandler {
    private final InvocationHandler _handler;
    private ManagedConnection _connection;
    private final ConnectionFactory _resolver;

    public ContextInvocationHandler(InvocationHandler handler, ConnectionFactory resolver, ManagedConnection connection) {
        this._handler = handler;
        this._resolver = resolver;
        this._connection = connection;
    }

    public void invoke(Invocation invocation) {
        this._handler.invoke(new ContextInvocation(invocation));
    }

    private class ContextInvocation
    implements Invocation {
        private final Invocation _invocation;

        public ContextInvocation(Invocation invocation) {
            this._invocation = invocation;
        }

        public Request getRequest() throws Throwable {
            ConnectionContext.push(ContextInvocationHandler.this._connection.getPrincipal(), ContextInvocationHandler.this._resolver);
            return this._invocation.getRequest();
        }

        public Caller getCaller() {
            return this._invocation.getCaller();
        }

        public void setResponse(Response response) {
            try {
                this._invocation.setResponse(response);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ConnectionContext.pop();
                throw throwable;
            }
            ConnectionContext.pop();
        }
    }
}

