/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.connector;

import java.security.Principal;
import org.exolab.jms.net.connector.Connection;
import org.exolab.jms.net.connector.ConnectionContext;
import org.exolab.jms.net.connector.ConnectionFactory;
import org.exolab.jms.net.connector.DefaultConnectionPool;
import org.exolab.jms.net.connector.InvocationHandler;
import org.exolab.jms.net.connector.ManagedConnection;
import org.exolab.jms.net.connector.ManagedConnectionListener;
import org.exolab.jms.net.connector.Request;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.connector.Response;
import org.exolab.jms.net.uri.URI;

final class ManagedConnectionHandle
implements ManagedConnection {
    private final DefaultConnectionPool _pool;
    private final ManagedConnection _connection;
    private final ConnectionFactory _resolver;
    private int _connectionCount = 0;
    private boolean _used = false;
    private boolean _pinging = false;
    private int _pingWaits;

    public ManagedConnectionHandle(DefaultConnectionPool pool, ManagedConnection connection, ConnectionFactory resolver) {
        this._pool = pool;
        this._connection = connection;
        this._resolver = resolver;
    }

    public void setInvocationHandler(InvocationHandler handler) throws ResourceException {
        this._connection.setInvocationHandler(handler);
    }

    public void setConnectionEventListener(ManagedConnectionListener listener) throws ResourceException {
        this._connection.setConnectionEventListener(listener);
    }

    public Connection getConnection() throws ResourceException {
        Connection connection = this._connection.getConnection();
        return new ConnectionHandle(connection);
    }

    public synchronized void ping() throws ResourceException {
        try {
            this._pinging = true;
            this._pingWaits = 0;
            this._connection.ping();
        }
        catch (ResourceException exception) {
            this._pinging = false;
            throw exception;
        }
    }

    public synchronized boolean pinging() {
        return this._pinging;
    }

    public synchronized void pinged() {
        this._pinging = false;
        this._pingWaits = 0;
    }

    public synchronized int incPingWaits() {
        return ++this._pingWaits;
    }

    public URI getRemoteURI() throws ResourceException {
        return this._connection.getRemoteURI();
    }

    public URI getLocalURI() throws ResourceException {
        return this._connection.getLocalURI();
    }

    public Principal getPrincipal() throws ResourceException {
        return this._connection.getPrincipal();
    }

    public void destroy() throws ResourceException {
        this._connection.destroy();
    }

    public synchronized void setUsed() {
        this._used = true;
    }

    public synchronized boolean used() {
        return this._used;
    }

    public synchronized void clearUsed() {
        this._used = false;
    }

    public synchronized boolean canDestroy() {
        return this._connectionCount == 0 && !this._used;
    }

    private synchronized void incActiveConnections() {
        ++this._connectionCount;
    }

    private synchronized void decActiveConnections() {
        --this._connectionCount;
        if (this._connectionCount <= 0) {
            this._pool.idle(this);
        }
    }

    public boolean usedSinceLastPing() {
        return false;
    }

    private class ConnectionHandle
    implements Connection {
        private Connection _connection;

        public ConnectionHandle(Connection connection) {
            this._connection = connection;
            ManagedConnectionHandle.this.incActiveConnections();
        }

        public Response invoke(Request request) throws Throwable {
            Response response = null;
            ManagedConnectionHandle.this.setUsed();
            try {
                ConnectionContext.push(ManagedConnectionHandle.this.getPrincipal(), ManagedConnectionHandle.this._resolver);
                response = this._connection.invoke(request);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ConnectionContext.pop();
                throw throwable;
            }
            ConnectionContext.pop();
            return response;
        }

        public URI getRemoteURI() throws ResourceException {
            return this._connection.getRemoteURI();
        }

        public URI getLocalURI() throws ResourceException {
            return this._connection.getLocalURI();
        }

        public void close() throws ResourceException {
            try {
                this._connection.close();
                Object var2_1 = null;
                this._connection = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this._connection = null;
                ManagedConnectionHandle.this.decActiveConnections();
                throw throwable;
            }
            ManagedConnectionHandle.this.decActiveConnections();
        }

        protected void finalize() throws Throwable {
            if (this._connection != null) {
                ManagedConnectionHandle.this.decActiveConnections();
            }
            super.finalize();
        }
    }
}

