/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.connector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.exolab.jms.net.util.SerializationHelper;

public class Response
implements Serializable {
    private Object _object;
    private Throwable _exception;
    private transient Method _method;

    public Response(Object object, Method method) {
        this._object = object;
        this._method = method;
    }

    public Response(Throwable exception) {
        this._exception = exception;
    }

    public Object getObject() {
        return this._object;
    }

    public Throwable getException() {
        return this._exception;
    }

    public boolean isReturn() {
        return this._exception == null;
    }

    public boolean isException() {
        return !this.isReturn();
    }

    public void write(ObjectOutput out) throws IOException {
        boolean normal = this.isReturn();
        out.writeBoolean(normal);
        if (normal) {
            Class<?> type = this._method.getReturnType();
            if (type != Void.TYPE) {
                SerializationHelper.write(type, this._object, out);
            }
        } else {
            out.writeObject(this._exception);
        }
    }

    public static Response read(ObjectInput in, Method method) throws ClassNotFoundException, IOException {
        Response response = null;
        boolean returnResponse = in.readBoolean();
        if (returnResponse) {
            Class<?> type = method.getReturnType();
            Object object = null;
            if (type != Void.TYPE) {
                object = SerializationHelper.read(type, in);
            }
            response = new Response(object, method);
        } else {
            Object object = in.readObject();
            response = new Response((Throwable)object);
        }
        return response;
    }
}

