/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.connector;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import org.exolab.jms.net.connector.ConnectionRequestInfo;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;
import org.exolab.jms.net.util.Properties;

public class URIRequestInfo
implements ConnectionRequestInfo {
    private URI _uri;
    private Principal _principal;

    public URIRequestInfo(URI uri) {
        this._uri = uri;
        this._principal = URIHelper.getPrincipal(uri);
    }

    public String getHost() {
        return this._uri.getHost();
    }

    public InetAddress getHostAddress() throws UnknownHostException {
        String host = this.getHost();
        return host != null ? InetAddress.getByName(host) : null;
    }

    public int getPort() {
        return this._uri.getPort();
    }

    public URI getURI() {
        return this._uri;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public void export(Properties properties) {
        properties.set("org.exolab.jms.net.orb.provider.uri", this._uri);
    }

    public boolean equals(Object other) {
        boolean equal;
        boolean bl = equal = this == other;
        if (!equal && other instanceof URIRequestInfo) {
            URIRequestInfo info = (URIRequestInfo)other;
            equal = this._uri.equals(info._uri);
        }
        return equal;
    }

    public int hashCode() {
        return this._uri.hashCode();
    }
}

