/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.http;

import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ConnectionFactory;
import org.exolab.jms.net.connector.ConnectionManager;
import org.exolab.jms.net.connector.ConnectionRequestInfo;
import org.exolab.jms.net.connector.ManagedConnection;
import org.exolab.jms.net.connector.ManagedConnectionAcceptor;
import org.exolab.jms.net.connector.ManagedConnectionFactory;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.http.AbstractHTTPManagedConnection;
import org.exolab.jms.net.http.HTTPRequestInfo;
import org.exolab.jms.net.socket.SocketManagedConnectionAcceptor;
import org.exolab.jms.net.socket.SocketRequestInfo;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;

public abstract class AbstractHTTPManagedConnectionFactory
implements ManagedConnectionFactory {
    public ManagedConnection matchManagedConnections(List connections, Principal principal, ConnectionRequestInfo info) throws ResourceException {
        AbstractHTTPManagedConnection result = null;
        if (info instanceof HTTPRequestInfo) {
            HTTPRequestInfo requestInfo = (HTTPRequestInfo)info;
            URI uri = URIHelper.convertHostToAddress(requestInfo.getURI());
            Iterator iterator = connections.iterator();
            while (iterator.hasNext()) {
                AbstractHTTPManagedConnection connection = (AbstractHTTPManagedConnection)iterator.next();
                if (!connection.hasPrincipal(principal) || !uri.equals(connection.getRemoteURI()) && !uri.equals(connection.getLocalURI())) continue;
                result = connection;
                break;
            }
        }
        return result;
    }

    public ManagedConnectionAcceptor matchManagedConnectionAcceptors(List acceptors, ConnectionRequestInfo info) throws ResourceException {
        SocketManagedConnectionAcceptor result = null;
        if (info instanceof SocketRequestInfo) {
            Iterator iterator = acceptors.iterator();
            while (iterator.hasNext()) {
                SocketManagedConnectionAcceptor acceptor = (SocketManagedConnectionAcceptor)iterator.next();
                if (!info.equals(acceptor.getRequestInfo())) continue;
                result = acceptor;
                break;
            }
        }
        return result;
    }

    public abstract ManagedConnectionAcceptor createManagedConnectionAcceptor(Authenticator var1, ConnectionRequestInfo var2) throws ResourceException;

    public abstract ManagedConnection createManagedConnection(Principal var1, ConnectionRequestInfo var2) throws ResourceException;

    public abstract ConnectionFactory createConnectionFactory(ConnectionManager var1) throws ResourceException;
}

