/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.exolab.jms.net.http.HTTPInputStream;
import org.exolab.jms.net.http.HTTPOutputStream;
import org.exolab.jms.net.http.HTTPRequestInfo;
import org.exolab.jms.net.http.TunnelHelper;
import org.exolab.jms.net.multiplexer.Endpoint;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.util.SSLHelper;

class HTTPEndpoint
implements Endpoint {
    private final URL _url;
    private final String _id;
    private final URI _uri;
    private HTTPInputStream _in;
    private HTTPOutputStream _out;
    private HTTPRequestInfo _info;
    private static final String OPEN_RESPONSE = "OPEN ";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";

    public HTTPEndpoint(HTTPRequestInfo info) throws IOException {
        int bufferSize = 2048;
        this._uri = info.getURI();
        this._url = new URL(this._uri.toString());
        this._info = info;
        boolean isSSL = this._uri.getScheme().equals("https");
        if (isSSL && info.getSSLProperties() != null) {
            SSLHelper.configure(info.getSSLProperties());
        }
        if (this._info.getProxyHost() != null) {
            System.setProperty("proxySet", "true");
            String hostProp = isSSL ? HTTPS_PROXY_HOST : HTTP_PROXY_HOST;
            String portProp = isSSL ? HTTPS_PROXY_PORT : HTTP_PROXY_PORT;
            try {
                System.setProperty(hostProp, this._info.getProxyHost());
                if (this._info.getProxyPort() != 0) {
                    System.setProperty(portProp, "" + this._info.getProxyPort());
                }
            }
            catch (SecurityException exception) {
                throw new ConnectException("Failed to set proxy system properties: " + exception.getMessage());
            }
        }
        HttpURLConnection connection = this.getConnection("open");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = reader.readLine();
            if (line == null || !line.startsWith(OPEN_RESPONSE)) {
                throw new IOException("Invalid response returned from URL=" + this._url + ": " + line);
            }
            this._id = line.substring(line.indexOf(OPEN_RESPONSE) + OPEN_RESPONSE.length());
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        this._in = new HTTPInputStream(this._id, this._url, info);
        this._out = new HTTPOutputStream(this._id, this._url, 2048, info);
    }

    public URI getURI() {
        return this._uri;
    }

    public InputStream getInputStream() throws IOException {
        return this._in;
    }

    public OutputStream getOutputStream() throws IOException {
        return this._out;
    }

    public void close() throws IOException {
        try {
            this.getConnection("close");
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._in.close();
            this._out.close();
            throw throwable;
        }
        this._in.close();
        this._out.close();
    }

    private HttpURLConnection getConnection(String action) throws IOException {
        return TunnelHelper.connect(this._url, this._id, action, this._info);
    }
}

