/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.http.HTTPRequestInfo;
import org.exolab.jms.net.http.TunnelHelper;

class HTTPInputStream
extends InputStream {
    private final String _id;
    private final URL _url;
    private final HTTPRequestInfo _info;
    private InputStream _in;
    private byte[] _data = new byte[1024];
    private final byte[] _byte = new byte[1];
    private int _index = 0;
    private int _available = 0;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$http$HTTPInputStream == null ? (class$org$exolab$jms$net$http$HTTPInputStream = HTTPInputStream.class$("org.exolab.jms.net.http.HTTPInputStream")) : class$org$exolab$jms$net$http$HTTPInputStream));
    static /* synthetic */ Class class$org$exolab$jms$net$http$HTTPInputStream;

    public HTTPInputStream(String id, URL url, HTTPRequestInfo info) {
        this._id = id;
        this._url = url;
        this._info = info;
    }

    public int read() throws IOException {
        int mask = 255;
        int count = this.read(this._byte, 0, 1);
        return count == 1 ? this._byte[0] & 0xFF : -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int count = 0;
        if (offset < 0 || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length > 0) {
            if (this._available == 0) {
                try {
                    this.doRead();
                }
                catch (IOException exception) {
                    _log.debug((Object)exception, (Throwable)exception);
                    throw exception;
                }
            }
            int n = count = length <= this._available ? length : this._available;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("read(length=" + length + "), [id=" + this._id + ", available=" + this._available + "]"));
            }
            if (count > 0) {
                System.arraycopy(this._data, this._index, buffer, offset, count);
                this._index += count;
                this._available -= count;
            }
        }
        return count;
    }

    protected int doRead() throws IOException {
        int count = 0;
        boolean done = false;
        while (!done) {
            if (this._in == null) {
                this.connect();
                done = true;
            }
            if ((count = this._in.read(this._data)) != -1) {
                this._available = count;
                this._index = 0;
                done = true;
                continue;
            }
            this._in.close();
            this._in = null;
        }
        return count;
    }

    private void connect() throws IOException {
        int length = 0;
        URLConnection connection = null;
        while (length == 0) {
            connection = TunnelHelper.connect(this._url, this._id, "read", this._info);
            length = connection.getContentLength();
            if (length == -1 || length != 0) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._in = connection.getInputStream();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("connect(), [id=" + this._id + ", contentLength=" + length + "]"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

