/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.http.HTTPRequestInfo;
import org.exolab.jms.net.http.TunnelHelper;

class HTTPOutputStream
extends OutputStream {
    private final String _id;
    private final URL _url;
    private final HTTPRequestInfo _info;
    private final byte[] _data;
    private int _index;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$http$HTTPOutputStream == null ? (class$org$exolab$jms$net$http$HTTPOutputStream = HTTPOutputStream.class$("org.exolab.jms.net.http.HTTPOutputStream")) : class$org$exolab$jms$net$http$HTTPOutputStream));
    static /* synthetic */ Class class$org$exolab$jms$net$http$HTTPOutputStream;

    public HTTPOutputStream(String id, URL url, int size, HTTPRequestInfo info) {
        this._id = id;
        this._url = url;
        this._data = new byte[size];
        this._info = info;
    }

    public void flush() throws IOException {
        while (this._index > 0) {
            this.doWrite();
        }
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        int space = this._data.length - this._index;
        if (space >= length) {
            System.arraycopy(buffer, offset, this._data, this._index, length);
            this._index += length;
        } else {
            this.flush();
            this.doWrite(buffer, offset, length);
        }
    }

    public void write(int value) throws IOException {
        while (this._index >= this._data.length) {
            this.flush();
        }
        this._data[this._index++] = (byte)value;
    }

    private void doWrite() throws IOException {
        try {
            this.doWrite(this._data, 0, this._index);
            this._index = 0;
        }
        catch (IOException exception) {
            _log.debug((Object)exception, (Throwable)exception);
            throw exception;
        }
    }

    private void doWrite(byte[] buffer, int offset, int length) throws IOException {
        HttpURLConnection connection = TunnelHelper.create(this._url, this._id, "write", this._info);
        connection.setDoOutput(true);
        OutputStream out = connection.getOutputStream();
        out.write(buffer, offset, length);
        out.close();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("doWrite(length=" + length + "), [id=" + this._id + "]"));
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException(connection.getResponseCode() + " " + connection.getResponseMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

